/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.DirectCompactSketch;
import org.apache.datasketches.theta.HashIterator;
import org.apache.datasketches.theta.MemoryCompactCompressedHashIterator;
import org.apache.datasketches.theta.PreambleUtil;
import org.apache.datasketches.thetacommon.ThetaUtil;

class DirectCompactCompressedSketch
extends DirectCompactSketch {
    private static final int START_PACKED_DATA_EXACT_MODE = 8;
    private static final int START_PACKED_DATA_ESTIMATION_MODE = 16;

    DirectCompactCompressedSketch(Memory mem) {
        super(mem);
    }

    static DirectCompactCompressedSketch wrapInstance(Memory srcMem, short seedHash) {
        ThetaUtil.checkSeedHashes((short)PreambleUtil.extractSeedHash(srcMem), seedHash);
        return new DirectCompactCompressedSketch(srcMem);
    }

    @Override
    public CompactSketch compact(boolean dstOrdered, WritableMemory dstMem) {
        if (dstMem != null) {
            this.mem_.copyTo(0L, dstMem, 0L, (long)this.getCurrentBytes());
            return new DirectCompactSketch((Memory)dstMem);
        }
        return CompactSketch.heapify(this.mem_);
    }

    @Override
    public int getCurrentBytes() {
        int preLongs = PreambleUtil.extractPreLongs(this.mem_);
        int entryBits = PreambleUtil.extractEntryBitsV4(this.mem_);
        int numEntriesBytes = PreambleUtil.extractNumEntriesBytesV4(this.mem_);
        return preLongs * 8 + numEntriesBytes + PreambleUtil.wholeBytesToHoldBits(this.getRetainedEntries() * entryBits);
    }

    @Override
    public int getRetainedEntries(boolean valid) {
        int preLongs = PreambleUtil.extractPreLongs(this.mem_);
        int numEntriesBytes = PreambleUtil.extractNumEntriesBytesV4(this.mem_);
        int offsetBytes = preLongs > 1 ? 16 : 8;
        int numEntries = 0;
        for (int i = 0; i < numEntriesBytes; ++i) {
            numEntries |= Byte.toUnsignedInt(this.mem_.getByte((long)offsetBytes++)) << (i << 3);
        }
        return numEntries;
    }

    @Override
    public long getThetaLong() {
        int preLongs = PreambleUtil.extractPreLongs(this.mem_);
        return preLongs > 1 ? PreambleUtil.extractThetaLongV4(this.mem_) : Long.MAX_VALUE;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean isOrdered() {
        return true;
    }

    @Override
    public HashIterator iterator() {
        return new MemoryCompactCompressedHashIterator(this.mem_, (PreambleUtil.extractPreLongs(this.mem_) > 1 ? 16 : 8) + PreambleUtil.extractNumEntriesBytesV4(this.mem_), PreambleUtil.extractEntryBitsV4(this.mem_), this.getRetainedEntries());
    }

    @Override
    long[] getCache() {
        int numEntries = this.getRetainedEntries();
        long[] cache = new long[numEntries];
        int i = 0;
        HashIterator it = this.iterator();
        while (it.next()) {
            cache[i++] = it.get();
        }
        return cache;
    }
}

