/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors;

import java.io.Serializable;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.iapi.DaffodilTunables;
import org.apache.daffodil.lib.iapi.Diagnostic;
import org.apache.daffodil.lib.util.Maybe$;
import org.apache.daffodil.lib.util.Maybe$One$;
import org.apache.daffodil.lib.util.Misc$;
import org.apache.daffodil.lib.xml.GlobalQName;
import org.apache.daffodil.lib.xml.GlobalQName$;
import org.apache.daffodil.lib.xml.NamedQName;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.runtime1.dpath.ExpressionEvaluationException;
import org.apache.daffodil.runtime1.dpath.UnparserNonBlocking$;
import org.apache.daffodil.runtime1.dsom.DPathCompileInfo;
import org.apache.daffodil.runtime1.infoset.InfosetException;
import org.apache.daffodil.runtime1.processors.CompileState;
import org.apache.daffodil.runtime1.processors.EvalCache;
import org.apache.daffodil.runtime1.processors.Evaluatable$;
import org.apache.daffodil.runtime1.processors.ParseOrUnparseState;
import org.apache.daffodil.runtime1.processors.VariableException;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.xml.Utility$;

public abstract class Evaluatable<T>
implements Serializable {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Evaluatable.class.getDeclaredField("qName$lzy1"));
    private final DPathCompileInfo ci;
    private NamedQName qNameArg;
    private boolean isCompiled_;
    private volatile Object qName$lzy1;
    private Object constValue_;

    public static <T> NamedQName $lessinit$greater$default$2() {
        return Evaluatable$.MODULE$.$lessinit$greater$default$2();
    }

    public Evaluatable(DPathCompileInfo ci, NamedQName qNameArg) {
        this.ci = ci;
        this.qNameArg = qNameArg;
        this.isCompiled_ = false;
        this.constValue_ = Maybe$.MODULE$.Nope();
    }

    public DPathCompileInfo ci() {
        return this.ci;
    }

    public abstract Seq<Evaluatable<Object>> runtimeDependencies();

    public boolean isNeverConstant() {
        return false;
    }

    public final boolean isCompiled() {
        return this.isCompiled_;
    }

    public final void ensureCompiled() {
        this.ci().initialize();
        if (!this.isCompiled()) {
            throw Assert$.MODULE$.invariantFailed("not compiled Ev: " + this.qName());
        }
    }

    private Object compileTimeEvaluate(CompileState state) {
        Object object;
        if (this.isCompiled()) {
            throw new IllegalStateException("already compiled");
        }
        this.isCompiled_ = true;
        try {
            T v = this.evaluate(state);
            object = Maybe$One$.MODULE$.apply(v);
        }
        catch (ExpressionEvaluationException expressionEvaluationException) {
            object = Maybe$.MODULE$.Nope();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InfosetException) {
                object = Maybe$.MODULE$.Nope();
            }
            if (throwable2 instanceof VariableException) {
                object = Maybe$.MODULE$.Nope();
            }
            throw throwable;
        }
        Object result = object;
        return result;
    }

    public GlobalQName dafName(String local) {
        return GlobalQName$.MODULE$.apply((Option<String>)Some$.MODULE$.apply((Object)"dafint"), local, XMLUtils$.MODULE$.dafintURI());
    }

    public Object maybeUseUnparserMode() {
        return Maybe$.MODULE$.apply(UnparserNonBlocking$.MODULE$);
    }

    public String toString() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("(%s@%x, %s)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.qName(), BoxesRunTime.boxToInteger((int)this.hashCode()), this.isConstant() ? "constant: " + this.constValue() : "runtime"}));
    }

    public String toBriefXML(int depth) {
        if (this.isConstant()) {
            return this.constValue().toString();
        }
        return this.toString();
    }

    public int toBriefXML$default$1() {
        return -1;
    }

    public NamedQName qName() {
        Object object = this.qName$lzy1;
        if (object instanceof NamedQName) {
            return (NamedQName)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (NamedQName)this.qName$lzyINIT1();
    }

    private Object qName$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.qName$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    NamedQName namedQName = null;
                    try {
                        namedQName = this.qNameArg == null ? this.dafName(Misc$.MODULE$.getNameFromClass(this)) : this.qNameArg;
                        object2 = namedQName == null ? LazyVals.NullValue$.MODULE$ : namedQName;
                        this.qNameArg = null;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.qName$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return namedQName;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public abstract T getCachedOrComputeAndCache(ParseOrUnparseState var1);

    public abstract T compute(ParseOrUnparseState var1);

    public final T evaluate(ParseOrUnparseState state) {
        if (this.isConstant()) {
            return this.constValue();
        }
        ParseOrUnparseState parseOrUnparseState = state;
        if (parseOrUnparseState instanceof CompileState) {
            return this.compute(state);
        }
        return this.getCachedOrComputeAndCache(state);
    }

    public final Object maybeConstant() {
        return Maybe$.MODULE$.fromMaybeAnyRef(this.constValue_);
    }

    public final boolean isConstant() {
        Object object = this.constValue_;
        return Maybe$.MODULE$.isDefined$extension(object);
    }

    public final T constValue() {
        Object object = this.maybeConstant();
        return Maybe$.MODULE$.get$extension(object);
    }

    public final Option<T> optConstant() {
        Object object = this.maybeConstant();
        return Maybe$.MODULE$.toOption$extension(object);
    }

    public final Object compile(CompileState state) {
        Object y;
        if (this.isNeverConstant()) {
            this.isCompiled_ = true;
            return Maybe$.MODULE$.Nope();
        }
        this.constValue_ = y = this.compileTimeEvaluate(state);
        return y;
    }

    public final Object compile(DaffodilTunables tunable) {
        CompileState compState = new CompileState(this.ci(), Maybe$.MODULE$.Nope(), tunable);
        return this.compile(compState);
    }

    public String toPseudoXML(EvalCache cache) {
        String pseudoAttributeName = this.qName().toAttributeNameString();
        Object thing = cache.get(this);
        String it = Maybe$.MODULE$.isDefined$extension(thing) ? Maybe$.MODULE$.value$extension(thing) : "Nope";
        String stringValueUnlimited = XMLUtils$.MODULE$.remapXMLIllegalCharactersToPUA(it.toString());
        String truncated = stringValueUnlimited.length() > 60 ? "...(truncated)" : "";
        String stringValue = stringValueUnlimited.substring(0, package$.MODULE$.min(60, stringValueUnlimited.length())) + truncated;
        if (stringValue.contains("]]>")) {
            throw Assert$.MODULE$.usageError("stringValue.contains(\"]]>\").unary_!");
        }
        String pseudoXMLStringValue = stringValue.contains("<") && !stringValue.contains("\"") ? "<![CDATA[" + stringValue + "]]>" : Utility$.MODULE$.escape(stringValue);
        String res = pseudoAttributeName + "=\"" + pseudoXMLStringValue + "\"";
        return res;
    }

    public Nothing$ toSDE(Diagnostic e, ParseOrUnparseState state) {
        return state.SDE(e);
    }
}

