/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.transfer.resourcefactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.ReferenceParametersType;
import org.apache.cxf.ws.transfer.Create;
import org.apache.cxf.ws.transfer.CreateResponse;
import org.apache.cxf.ws.transfer.Representation;
import org.apache.cxf.ws.transfer.dialect.Dialect;
import org.apache.cxf.ws.transfer.resourcefactory.ResourceFactory;
import org.apache.cxf.ws.transfer.resourcefactory.resolver.ResourceReference;
import org.apache.cxf.ws.transfer.resourcefactory.resolver.ResourceResolver;
import org.apache.cxf.ws.transfer.shared.faults.UnknownDialect;
import org.apache.cxf.ws.transfer.validationtransformation.ResourceTypeIdentifier;
import org.apache.cxf.ws.transfer.validationtransformation.ValidAndTransformHelper;

public class ResourceFactoryImpl
implements ResourceFactory {
    protected ResourceResolver resourceResolver;
    protected List<ResourceTypeIdentifier> resourceTypeIdentifiers;
    protected Map<String, Dialect> dialects = new HashMap<String, Dialect>();

    @Override
    public CreateResponse create(Create body) {
        if (body.getDialect() != null && !body.getDialect().isEmpty()) {
            if (this.dialects.containsKey(body.getDialect())) {
                Dialect dialect = this.dialects.get(body.getDialect());
                Representation representation = dialect.processCreate(body);
                body.setRepresentation(representation);
            } else {
                throw new UnknownDialect();
            }
        }
        ValidAndTransformHelper.validationAndTransformation(this.resourceTypeIdentifiers, body.getRepresentation(), null);
        ResourceReference resourceReference = this.resourceResolver.resolve(body);
        if (resourceReference.getResourceManager() != null) {
            return this.createLocally(body, resourceReference);
        }
        return this.createRemotely(body, resourceReference);
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public void setResourceResolver(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public List<ResourceTypeIdentifier> getResourceTypeIdentifiers() {
        if (this.resourceTypeIdentifiers == null) {
            this.resourceTypeIdentifiers = new ArrayList<ResourceTypeIdentifier>();
        }
        return this.resourceTypeIdentifiers;
    }

    public void setResourceTypeIdentifiers(List<ResourceTypeIdentifier> resourceTypeIdentifiers) {
        this.resourceTypeIdentifiers = resourceTypeIdentifiers;
    }

    public void registerDialect(String uri, Dialect dialect) {
        if (this.dialects.containsKey(uri)) {
            throw new IllegalArgumentException(String.format("URI \"%s\" is already registered", uri));
        }
        this.dialects.put(uri, dialect);
    }

    public void unregisterDialect(String uri) {
        if (!this.dialects.containsKey(uri)) {
            throw new IllegalArgumentException(String.format("URI \"%s\" is not registered", uri));
        }
        this.dialects.remove(uri);
    }

    private CreateResponse createLocally(Create body, ResourceReference ref) {
        Representation representation = body.getRepresentation();
        ReferenceParametersType refParams = ref.getResourceManager().create(representation);
        CreateResponse response = new CreateResponse();
        response.setResourceCreated(new EndpointReferenceType());
        response.getResourceCreated().setAddress(new AttributedURIType());
        response.getResourceCreated().getAddress().setValue(ref.getResourceURL());
        response.getResourceCreated().setReferenceParameters(refParams);
        response.setRepresentation(body.getRepresentation());
        return response;
    }

    private CreateResponse createRemotely(Create body, ResourceReference ref) {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(ResourceFactory.class);
        factory.setAddress(ref.getResourceURL() + "_factory");
        ResourceFactory client = (ResourceFactory)factory.create();
        CreateResponse response = client.create(body);
        response.getResourceCreated().setAddress(new AttributedURIType());
        response.getResourceCreated().getAddress().setValue(ref.getResourceURL());
        return response;
    }
}

