/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.filesystem.impl;

import com.terracottatech.offheapstore.filesystem.Directory;
import com.terracottatech.offheapstore.filesystem.FileSystem;
import com.terracottatech.offheapstore.filesystem.impl.OffheapDirectory;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.ehcache.shadow.org.terracotta.offheapstore.paging.PageSource;
import org.ehcache.shadow.org.terracotta.offheapstore.util.MemoryUnit;

public class OffheapFileSystem
implements FileSystem {
    private final ConcurrentHashMap<String, Directory> directories = new ConcurrentHashMap();
    private final PageSource pageSource;
    private final int blockSize;
    private final int maxDataPageSize;
    private final int concurrency;
    private static final int DEFAULT_BLOCK_SIZE = MemoryUnit.KILOBYTES.toBytes(8);
    private static final int DEFAULT_MAX_DATA_PAGE_SIZE = MemoryUnit.KILOBYTES.toBytes(256);
    private static final int DEFAULT_CONCURRENCY = 4;

    public OffheapFileSystem(PageSource source) {
        this(source, DEFAULT_BLOCK_SIZE, DEFAULT_MAX_DATA_PAGE_SIZE, 4);
    }

    public OffheapFileSystem(PageSource source, int blockSize, int maxDataPageSize, int concurrency) {
        this.pageSource = source;
        this.blockSize = blockSize;
        this.maxDataPageSize = maxDataPageSize;
        this.concurrency = concurrency;
    }

    @Override
    public synchronized Directory getOrCreateDirectory(String name) throws IOException {
        Directory racer;
        if (name == null) {
            throw new NullPointerException("name of the directory is null");
        }
        Directory existing = this.directories.get(name);
        if (existing == null && (racer = this.directories.putIfAbsent(name, existing = new OffheapDirectory(name, this.pageSource, this.blockSize, this.maxDataPageSize, this.concurrency))) != null) {
            existing = racer;
        }
        return existing;
    }

    @Override
    public Set<String> listDirectories() throws IOException {
        return Collections.unmodifiableSet(this.directories.keySet());
    }

    @Override
    public synchronized void deleteDirectory(String name) throws IOException, FileNotFoundException {
        Directory dir = this.directories.remove(name);
        if (dir == null) {
            throw new FileNotFoundException(name);
        }
        dir.deleteAllFiles();
    }

    @Override
    public void delete() throws IOException {
        Iterator<Directory> it = this.directories.values().iterator();
        while (it.hasNext()) {
            Directory removed = it.next();
            it.remove();
            removed.deleteAllFiles();
        }
    }

    @Override
    public boolean directoryExists(String name) throws IOException {
        return this.directories.containsKey(name);
    }
}

