/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.group.impl;

import java.io.Serializable;
import java.util.Objects;
import org.apache.activemq.artemis.api.config.ActiveMQDefaultConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;

public final class GroupingHandlerConfiguration
implements Serializable {
    public static final long serialVersionUID = -4600283023652477326L;
    public static final String GROUP_TIMEOUT_PROP_NAME = "org.apache.activemq.GroupingHandlerConfiguration.groupTimeout";
    public static final String REAPER_PERIOD_PROP_NAME = "org.apache.activemq.GroupingHandlerConfiguration.reaperPeriod";
    private SimpleString name = null;
    private TYPE type = null;
    private SimpleString address = null;
    private long timeout = ActiveMQDefaultConfiguration.getDefaultGroupingHandlerTimeout();
    private long groupTimeout = ActiveMQDefaultConfiguration.getDefaultGroupingHandlerGroupTimeout();
    private long reaperPeriod = ActiveMQDefaultConfiguration.getDefaultGroupingHandlerReaperPeriod();

    public GroupingHandlerConfiguration() {
        if (System.getProperty(GROUP_TIMEOUT_PROP_NAME) != null) {
            this.groupTimeout = Long.parseLong(System.getProperty(GROUP_TIMEOUT_PROP_NAME));
        }
        if (System.getProperty(REAPER_PERIOD_PROP_NAME) != null) {
            this.reaperPeriod = Long.parseLong(System.getProperty(REAPER_PERIOD_PROP_NAME));
        }
    }

    public SimpleString getName() {
        return this.name;
    }

    public TYPE getType() {
        return this.type;
    }

    public SimpleString getAddress() {
        return this.address;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getGroupTimeout() {
        return this.groupTimeout;
    }

    public long getReaperPeriod() {
        return this.reaperPeriod;
    }

    public GroupingHandlerConfiguration setName(SimpleString name) {
        this.name = name;
        return this;
    }

    public GroupingHandlerConfiguration setType(TYPE type) {
        this.type = type;
        return this;
    }

    public GroupingHandlerConfiguration setAddress(SimpleString address) {
        this.address = address;
        return this;
    }

    public GroupingHandlerConfiguration setTimeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    public GroupingHandlerConfiguration setGroupTimeout(long groupTimeout) {
        this.groupTimeout = groupTimeout;
        return this;
    }

    public GroupingHandlerConfiguration setReaperPeriod(long reaperPeriod) {
        this.reaperPeriod = reaperPeriod;
        return this;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.address, this.name, this.timeout, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GroupingHandlerConfiguration)) {
            return false;
        }
        GroupingHandlerConfiguration other = (GroupingHandlerConfiguration)obj;
        return Objects.equals(this.address, other.address) && Objects.equals(this.name, other.name) && this.timeout == other.timeout && this.type == other.type;
    }

    public static enum TYPE {
        LOCAL("LOCAL"),
        REMOTE("REMOTE");

        private String type;

        private TYPE(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }
    }
}

