/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jdbc.store.file;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQIOErrorException;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.io.buffer.TimedBuffer;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.impl.SimpleWaitIOCallback;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactory;
import org.apache.activemq.artemis.jdbc.store.file.JDBCSequentialFileFactoryDriver;
import org.apache.activemq.artemis.jdbc.store.file.ScheduledWrite;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.jctools.queues.MpscUnboundedArrayQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCSequentialFile
implements SequentialFile {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final String filename;
    private final String extension;
    private AtomicBoolean isOpen = new AtomicBoolean(false);
    private AtomicBoolean isLoaded = new AtomicBoolean(false);
    private long id = -1L;
    private long readPosition = 0L;
    private long writePosition = 0L;
    private final Executor executor;
    private final JDBCSequentialFileFactory fileFactory;
    private final JDBCSequentialFileFactoryDriver dbDriver;
    MpscUnboundedArrayQueue<ScheduledWrite> writeQueue = new MpscUnboundedArrayQueue(8192);
    private final Map<Object, Object> metaData = new ConcurrentHashMap<Object, Object>();
    final JDBCPageWriteScheduler pageWriteScheduler;
    final ScheduledExecutorService scheduledExecutorService;
    private final ReusableLatch pendingWrites = new ReusableLatch();
    final long syncDelay;

    JDBCSequentialFile(JDBCSequentialFileFactory fileFactory, String filename, Executor executor, ScheduledExecutorService scheduledExecutorService, long syncDelay, JDBCSequentialFileFactoryDriver driver) throws SQLException {
        this.fileFactory = fileFactory;
        this.filename = filename;
        this.extension = filename.contains(".") ? filename.substring(filename.lastIndexOf(".") + 1, filename.length()) : "";
        this.executor = executor;
        this.dbDriver = driver;
        this.scheduledExecutorService = scheduledExecutorService;
        this.syncDelay = syncDelay;
        this.pageWriteScheduler = new JDBCPageWriteScheduler(scheduledExecutorService, executor, syncDelay);
    }

    void setWritePosition(long writePosition) {
        this.writePosition = writePosition;
    }

    public boolean isOpen() {
        return this.isOpen.get();
    }

    public boolean exists() {
        try {
            return this.dbDriver.getFileID(this) >= 0L;
        }
        catch (Throwable e) {
            logger.warn(e.getMessage(), e);
            return false;
        }
    }

    public void open() throws Exception {
        this.isOpen.compareAndSet(false, this.load());
    }

    private boolean load() {
        try {
            if (this.isLoaded.compareAndSet(false, true)) {
                this.dbDriver.openFile(this);
            }
            return true;
        }
        catch (SQLException e) {
            this.isLoaded.set(false);
            return false;
        }
    }

    public void open(int maxIO, boolean useExecutor) throws Exception {
        this.open();
    }

    public boolean fits(int size) {
        return this.writePosition + (long)size <= this.dbDriver.getMaxSize();
    }

    public int calculateBlockStart(int position) throws Exception {
        return 0;
    }

    public String getFileName() {
        return this.filename;
    }

    public void fill(int size) throws Exception {
    }

    public ByteBuffer map(int position, long size) throws IOException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException, InterruptedException, ActiveMQException {
        try {
            JDBCSequentialFile jDBCSequentialFile = this;
            synchronized (jDBCSequentialFile) {
                if (this.load()) {
                    this.dbDriver.deleteFile(this);
                }
            }
        }
        catch (SQLException e) {
            logger.debug("Expected error deleting Sequential File", (Throwable)e);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int jdbcWrite(byte[] data, IOCallback callback, boolean append) {
        try {
            logger.debug("Writing {} bytes into {}", (Object)data.length, (Object)this.filename);
            JDBCSequentialFile jDBCSequentialFile = this;
            synchronized (jDBCSequentialFile) {
                int noBytes = this.dbDriver.writeToFile(this, data, append);
                this.seek(append ? this.writePosition + (long)noBytes : (long)noBytes);
                if (logger.isTraceEnabled()) {
                    logger.trace("Write: ID: {} FileName: {}{}", new Object[]{this.getId(), this.getFileName(), this.size()});
                }
                if (callback != null) {
                    callback.done();
                }
                return noBytes;
            }
        }
        catch (Exception e) {
            if (callback != null) {
                callback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), e.getMessage());
            }
            this.fileFactory.onIOError(e, "Error writing to JDBC file.", this);
            return 0;
        }
    }

    public synchronized int jdbcWrite(ActiveMQBuffer buffer, IOCallback callback) {
        return this.jdbcWrite(buffer, callback, true);
    }

    public synchronized int jdbcWrite(ActiveMQBuffer buffer, IOCallback callback, boolean append) {
        byte[] data = new byte[buffer.readableBytes()];
        buffer.readBytes(data);
        return this.jdbcWrite(data, callback, append);
    }

    private void pollWrites() {
        if (this.writeQueue.isEmpty()) {
            return;
        }
        logger.debug("polling {} elements on {}", (Object)this.writeQueue.size(), (Object)this.filename);
        ArrayList<ScheduledWrite> writeList = new ArrayList<ScheduledWrite>(this.writeQueue.size());
        byte[] bytes = this.extractBytes(writeList);
        this.jdbcWrite(bytes, null, true);
        writeList.forEach(this::doCallback);
    }

    private byte[] extractBytes(ArrayList<ScheduledWrite> writeList) {
        ScheduledWrite write;
        int totalSize = 0;
        while ((write = (ScheduledWrite)this.writeQueue.poll()) != null) {
            writeList.add(write);
            totalSize += write.readable();
        }
        byte[] bytes = new byte[totalSize];
        int writePosition = 0;
        for (ScheduledWrite el : writeList) {
            writePosition += el.readAt(bytes, writePosition);
            el.releaseBuffer();
        }
        return bytes;
    }

    private void doCallback(ScheduledWrite write) {
        if (write != null && write.callback != null) {
            write.callback.done();
        }
        this.pendingWrites.countDown();
    }

    private void scheduleWrite(ActiveMQBuffer bytes, IOCallback callback, boolean append) {
        this.scheduleWrite(new ScheduledWrite(bytes, callback, append));
    }

    private void scheduleWrite(ScheduledWrite scheduledWrite) {
        logger.debug("offering {} bytes into {}", (Object)scheduledWrite.readable(), (Object)this.filename);
        this.pendingWrites.countUp();
        this.writeQueue.offer((Object)scheduledWrite);
        this.pageWriteScheduler.delay();
    }

    private void scheduleWrite(ByteBuffer bytes, IOCallback callback) {
        this.scheduleWrite(new ScheduledWrite(bytes, callback, true));
    }

    synchronized void seek(long noBytes) {
        this.writePosition = noBytes;
    }

    public void sendToDB(ActiveMQBuffer bytes, IOCallback callback, boolean append) throws Exception {
        SimpleWaitIOCallback waitIOCallback = null;
        if (callback == null) {
            waitIOCallback = new SimpleWaitIOCallback();
            callback = waitIOCallback;
        }
        this.scheduleWrite(bytes, callback, append);
        if (callback != null) {
            waitIOCallback.waitCompletion();
        }
    }

    public void write(ActiveMQBuffer bytes, boolean sync, IOCallback callback) throws Exception {
        this.sendToDB(bytes, callback, true);
    }

    public void write(ActiveMQBuffer bytes, boolean sync) throws Exception {
        this.write(bytes, sync, null);
    }

    public void write(EncodingSupport bytes, boolean sync, IOCallback callback) throws Exception {
        ActiveMQBuffer data = ActiveMQBuffers.fixedBuffer((int)bytes.getEncodeSize());
        bytes.encode(data);
        this.sendToDB(data, callback, true);
    }

    public void write(EncodingSupport bytes, boolean sync) throws Exception {
        this.write(bytes, sync, null);
    }

    public void writeDirect(ByteBuffer bytes, boolean sync, IOCallback callback) {
        if (callback == null) {
            SimpleWaitIOCallback waitIOCallback = sync ? new SimpleWaitIOCallback() : null;
            try {
                this.scheduleWrite(bytes, (IOCallback)waitIOCallback);
                if (waitIOCallback != null) {
                    waitIOCallback.waitCompletion();
                }
            }
            catch (Exception e) {
                waitIOCallback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), "Error writing to JDBC file.");
                this.fileFactory.onIOError(e, "Failed to write to file.", this);
            }
        } else {
            this.scheduleWrite(bytes, callback);
        }
    }

    public void blockingWriteDirect(ByteBuffer bytes, boolean sync, boolean releaseBuffer) {
        this.writeDirect(bytes, sync, null);
    }

    public void writeDirect(ByteBuffer bytes, boolean sync) throws Exception {
        this.writeDirect(bytes, sync, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int read(ByteBuffer bytes, IOCallback callback) throws SQLException {
        JDBCSequentialFile jDBCSequentialFile = this;
        synchronized (jDBCSequentialFile) {
            try {
                int read = this.dbDriver.readFromFile(this, bytes);
                this.readPosition += (long)read;
                if (callback != null) {
                    callback.done();
                }
                return read;
            }
            catch (SQLException e) {
                if (callback != null) {
                    callback.onError(ActiveMQExceptionType.IO_ERROR.getCode(), e.getMessage());
                }
                this.fileFactory.onIOError(e, "Error reading from JDBC file.", this);
                return 0;
            }
        }
    }

    public int read(ByteBuffer bytes) throws Exception {
        return this.read(bytes, null);
    }

    public void position(long pos) throws IOException {
        this.readPosition = pos;
    }

    public long position() {
        return this.readPosition;
    }

    public void close() throws Exception {
        this.close(true, true);
    }

    public void close(boolean waitOnSync, boolean block) throws Exception {
        this.isOpen.set(false);
        if (waitOnSync) {
            this.sync();
        }
        this.fileFactory.sequentialFileClosed(this);
    }

    public int getNetworkTimeoutMillis() {
        return this.dbDriver.getJdbcConnectionProvider().getNetworkTimeoutMillis();
    }

    public void sync() throws IOException {
        try {
            int syncTimeout = this.getNetworkTimeoutMillis();
            if (syncTimeout >= 0) {
                if (!this.pendingWrites.await((long)syncTimeout, TimeUnit.MILLISECONDS)) {
                    this.fileFactory.onIOError((Throwable)new ActiveMQIOErrorException("Database not responding to syncs before timeout"), "Error during JDBC file sync.", this);
                }
            } else {
                while (!this.pendingWrites.await(1L, TimeUnit.SECONDS)) {
                    logger.debug("Awaiting syncs from database for page file {}", (Object)this.filename);
                }
            }
        }
        catch (Exception e) {
            this.fileFactory.onIOError(e, "Error during JDBC file sync.", this);
        }
    }

    public long size() throws Exception {
        this.load();
        return this.writePosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameTo(String newFileName) throws Exception {
        JDBCSequentialFile jDBCSequentialFile = this;
        synchronized (jDBCSequentialFile) {
            try {
                this.dbDriver.renameFile(this, newFileName);
            }
            catch (SQLException e) {
                this.fileFactory.onIOError(e, "Error renaming JDBC file.", this);
            }
        }
    }

    public SequentialFile cloneFile() {
        try {
            JDBCSequentialFile clone = new JDBCSequentialFile(this.fileFactory, this.filename, this.executor, this.scheduledExecutorService, this.syncDelay, this.dbDriver);
            clone.setWritePosition(this.writePosition);
            return clone;
        }
        catch (Exception e) {
            this.fileFactory.onIOError(e, "Error cloning JDBC file.", this);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyTo(SequentialFile cloneFile) throws Exception {
        JDBCSequentialFile clone = (JDBCSequentialFile)cloneFile;
        try {
            JDBCSequentialFile jDBCSequentialFile = this;
            synchronized (jDBCSequentialFile) {
                logger.trace("JDBC Copying File.  From: {} To: {}", (Object)this, (Object)cloneFile);
                clone.open();
                this.dbDriver.copyFileData(this, clone);
                clone.setWritePosition(this.writePosition);
            }
        }
        catch (Exception e) {
            this.fileFactory.onIOError(e, "Error copying JDBC file.", this);
        }
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setTimedBuffer(TimedBuffer buffer) {
    }

    public File getJavaFile() {
        return null;
    }

    public void addMetaData(Object key, Object value) {
        this.metaData.put(key, value);
    }

    public Object getMetaData(Object key) {
        return this.metaData.get(key);
    }

    private class JDBCPageWriteScheduler
    extends ActiveMQScheduledComponent {
        JDBCPageWriteScheduler(ScheduledExecutorService scheduledExecutorService, Executor executor, long checkPeriod) {
            super(scheduledExecutorService, executor, checkPeriod, TimeUnit.MILLISECONDS, true);
        }

        public void run() {
            JDBCSequentialFile.this.pollWrites();
        }
    }
}

