/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.impl;

import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQAddressFullException;
import org.apache.activemq.artemis.api.core.ActiveMQDisconnectedException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQInterruptedException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.RefCountMessage;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ClusterTopologyListener;
import org.apache.activemq.artemis.api.core.client.SendAcknowledgementHandler;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.api.core.client.TopologyMember;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.core.client.impl.ClientProducerCredits;
import org.apache.activemq.artemis.core.client.impl.ClientProducerFlowCallback;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorInternal;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.HandleStatus;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.cluster.Bridge;
import org.apache.activemq.artemis.core.server.cluster.impl.BridgeMetrics;
import org.apache.activemq.artemis.core.server.impl.QueueImpl;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationService;
import org.apache.activemq.artemis.core.server.transformer.Transformer;
import org.apache.activemq.artemis.spi.core.protocol.EmbedMessageUtil;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.spi.core.remoting.ReadyListener;
import org.apache.activemq.artemis.utils.FutureLatch;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgeImpl
implements Bridge,
SessionFailureListener,
SendAcknowledgementHandler,
ReadyListener,
ClientProducerFlowCallback {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final ServerLocatorInternal serverLocator;
    protected final Executor executor;
    protected final ScheduledExecutorService scheduledExecutor;
    private final ReusableLatch pendingAcks = new ReusableLatch(0);
    private final UUID nodeUUID;
    private final long sequentialID;
    protected final Queue queue;
    private final Filter filter;
    final Map<Long, MessageReference> refs = new LinkedHashMap<Long, MessageReference>();
    private final Transformer transformer;
    private final Object connectionGuard = new Object();
    private boolean blockedOnFlowControl;
    protected ScheduledFuture<?> futureScheduledReconnection;
    protected volatile ClientSessionInternal session;
    protected volatile ClientSessionInternal sessionConsumer;
    protected volatile boolean disconnectedAndDown = false;
    protected String targetNodeID;
    protected TopologyMember targetNode;
    private volatile ClientSessionFactoryInternal csf;
    private volatile ClientProducer producer;
    private volatile boolean started;
    private volatile boolean stopping = false;
    private volatile boolean active;
    private boolean deliveringLargeMessage;
    private int reconnectAttemptsInUse;
    private int retryCount = 0;
    private NotificationService notificationService;
    private boolean keepConnecting = true;
    private ActiveMQServer server;
    private final BridgeMetrics metrics = new BridgeMetrics();
    private BridgeConfiguration configuration;

    public BridgeImpl(ServerLocatorInternal serverLocator, BridgeConfiguration configuration, UUID nodeUUID, Queue queue, Executor executor, ScheduledExecutorService scheduledExecutor, ActiveMQServer server) throws ActiveMQException {
        this.sequentialID = server.getStorageManager().generateID();
        this.configuration = configuration;
        this.reconnectAttemptsInUse = configuration.getInitialConnectAttempts();
        this.serverLocator = serverLocator;
        this.nodeUUID = nodeUUID;
        this.queue = queue;
        this.executor = executor;
        this.scheduledExecutor = scheduledExecutor;
        this.transformer = server.getServiceRegistry().getBridgeTransformer(configuration.getName(), configuration.getTransformerConfiguration());
        this.filter = FilterImpl.createFilter(configuration.getFilterString());
        this.server = server;
    }

    public boolean isBlockedOnFlowControl() {
        return this.blockedOnFlowControl;
    }

    public static final byte[] getDuplicateBytes(UUID nodeUUID, long messageID) {
        byte[] bytes = new byte[24];
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        bb.put(nodeUUID.asBytes());
        bb.putLong(messageID);
        return bytes;
    }

    public ClientSessionFactory getSessionFactory() {
        return this.csf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<MessageReference> getDeliveringMessages() {
        Map<Long, MessageReference> map = this.refs;
        synchronized (map) {
            return new ArrayList<MessageReference>(this.refs.values());
        }
    }

    private static void cleanUpSessionFactory(ClientSessionFactoryInternal factory) {
        if (factory != null) {
            factory.cleanup();
        }
    }

    @Override
    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void onCreditsFlow(boolean blocked, ClientProducerCredits producerCredits) {
        if (logger.isTraceEnabled()) {
            logger.trace("Bridge {} received credits, with blocked = {}", (Object)this.getName(), (Object)blocked);
        }
        this.blockedOnFlowControl = blocked;
        if (!blocked) {
            this.queue.deliverAsync();
        }
    }

    public void onCreditsFail(ClientProducerCredits producerCredits) {
        ActiveMQServerLogger.LOGGER.bridgeAddressFull(String.valueOf(producerCredits.getAddress()), String.valueOf(this.getName()));
        this.disconnect();
    }

    @Override
    public long sequentialID() {
        return this.sequentialID;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.started = true;
        this.stopping = false;
        this.activate();
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(SimpleString.of((String)"name"), SimpleString.of((String)this.configuration.getName()));
            Notification notification = new Notification(this.nodeUUID.toString(), (NotificationType)CoreNotificationType.BRIDGE_STARTED, props);
            this.notificationService.sendNotification(notification);
        }
    }

    @Override
    public String debug() {
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelRefs() {
        LinkedList<MessageReference> list = new LinkedList<MessageReference>();
        Map<Long, MessageReference> map = this.refs;
        synchronized (map) {
            list.addAll(this.refs.values());
            this.refs.clear();
        }
        if (logger.isTraceEnabled()) {
            logger.trace("BridgeImpl::cancelRefs cancelling {} references", (Object)list.size());
        }
        if (logger.isTraceEnabled() && list.isEmpty()) {
            logger.trace("didn't have any references to cancel on bridge {}", (Object)this);
            return;
        }
        ListIterator listIterator = list.listIterator(list.size());
        long timeBase = System.currentTimeMillis();
        while (listIterator.hasPrevious()) {
            MessageReference ref = (MessageReference)listIterator.previous();
            logger.trace("BridgeImpl::cancelRefs Cancelling reference {} on bridge {}", (Object)ref, (Object)this);
            Queue refqueue = ref.getQueue();
            try {
                refqueue.cancel(ref, timeBase);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorCancellingRefOnBridge(ref, e);
            }
        }
    }

    @Override
    public void flushExecutor() {
        FutureLatch future = new FutureLatch();
        this.executor.execute((Runnable)future);
        boolean ok = future.await(10000L);
        if (!ok) {
            ActiveMQServerLogger.LOGGER.timedOutWaitingToStopBridge();
        }
    }

    @Override
    public void disconnect() {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                if (BridgeImpl.this.session != null) {
                    try {
                        BridgeImpl.this.session.cleanUp(false);
                    }
                    catch (Exception dontcare) {
                        logger.debug(dontcare.getMessage(), (Throwable)dontcare);
                    }
                    BridgeImpl.this.session = null;
                }
                if (BridgeImpl.this.sessionConsumer != null) {
                    try {
                        BridgeImpl.this.sessionConsumer.cleanUp(false);
                    }
                    catch (Exception dontcare) {
                        logger.debug(dontcare.getMessage(), (Throwable)dontcare);
                    }
                    BridgeImpl.this.sessionConsumer = null;
                }
            }
        });
    }

    @Override
    public boolean isConnected() {
        return this.session != null;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void stop() throws Exception {
        if (this.stopping) {
            return;
        }
        this.stopping = true;
        logger.debug("Bridge {} being stopped", (Object)this.configuration.getName());
        if (this.futureScheduledReconnection != null) {
            this.futureScheduledReconnection.cancel(true);
        }
        this.executor.execute(new StopRunnable());
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(SimpleString.of((String)"name"), SimpleString.of((String)this.configuration.getName()));
            Notification notification = new Notification(this.nodeUUID.toString(), (NotificationType)CoreNotificationType.BRIDGE_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.broadcastBridgeStoppedError(e);
            }
        }
    }

    @Override
    public void pause() throws Exception {
        logger.debug("Bridge {} being paused", (Object)this.configuration.getName());
        this.executor.execute(new PauseRunnable());
        if (this.notificationService != null) {
            TypedProperties props = new TypedProperties();
            props.putSimpleStringProperty(SimpleString.of((String)"name"), SimpleString.of((String)this.configuration.getName()));
            Notification notification = new Notification(this.nodeUUID.toString(), (NotificationType)CoreNotificationType.BRIDGE_STOPPED, props);
            try {
                this.notificationService.sendNotification(notification);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.notificationBridgeStoppedError(e);
            }
        }
    }

    @Override
    public void resume() throws Exception {
        this.queue.addConsumer(this);
        this.queue.deliverAsync();
    }

    public boolean isStarted() {
        return this.started;
    }

    public synchronized void activate() {
        this.executor.execute(new ConnectRunnable(this));
    }

    @Override
    public SimpleString getName() {
        return SimpleString.of((String)this.configuration.getName());
    }

    @Override
    public Queue getQueue() {
        return this.queue;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public SimpleString getForwardingAddress() {
        return SimpleString.of((String)this.configuration.getForwardingAddress());
    }

    @Override
    public RemotingConnection getForwardingConnection() {
        if (this.session == null) {
            return null;
        }
        return this.session.getConnection();
    }

    public void sendFailed(Message message, Exception e) {
        if (e instanceof ActiveMQAddressFullException) {
            logger.warn(e.getMessage(), (Throwable)e);
            this.failed(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAcknowledged(Message message) {
        logger.trace("BridgeImpl::sendAcknowledged received confirmation for message {}", (Object)message);
        if (this.active) {
            try {
                MessageReference ref;
                Map<Long, MessageReference> map = this.refs;
                synchronized (map) {
                    ref = this.refs.remove(message.getMessageID());
                }
                if (ref != null) {
                    if (logger.isTraceEnabled()) {
                        logger.trace("BridgeImpl::sendAcknowledged bridge {} Acking {} on queue {}", new Object[]{this, ref, ref.getQueue()});
                    }
                    ref.getQueue().acknowledge(ref);
                    this.pendingAcks.countDown();
                    this.metrics.incrementMessagesAcknowledged();
                    if (this.server.hasBrokerBridgePlugins()) {
                        this.server.callBrokerBridgePlugins(plugin -> plugin.afterAcknowledgeBridge(this, ref));
                    }
                } else {
                    logger.trace("BridgeImpl::sendAcknowledged bridge {} could not find reference for message {}", (Object)this, (Object)message);
                }
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.bridgeFailedToAck(e);
            }
        }
    }

    @Override
    public void failed(Throwable t) {
        if (t instanceof ActiveMQException) {
            this.connectionFailed((ActiveMQException)t, false);
        } else {
            ActiveMQException exception = new ActiveMQException(t.getMessage());
            exception.initCause(t);
            this.connectionFailed(exception, false);
        }
    }

    protected Message beforeForward(Message message, SimpleString forwardingAddress) {
        message = message.copy();
        ((RefCountMessage)message).setParentRef((RefCountMessage)message);
        return this.beforeForwardingNoCopy(message, forwardingAddress);
    }

    protected Message beforeForwardingNoCopy(Message message, SimpleString forwardingAddress) {
        if (this.configuration.isUseDuplicateDetection()) {
            byte[] bytes = BridgeImpl.getDuplicateBytes(this.nodeUUID, message.getMessageID());
            message.putExtraBytesProperty(Message.HDR_BRIDGE_DUPLICATE_ID, bytes);
        }
        if (forwardingAddress != null) {
            message.setAddress(forwardingAddress);
        }
        switch (this.configuration.getRoutingType()) {
            case ANYCAST: {
                message.setRoutingType(RoutingType.ANYCAST);
                break;
            }
            case MULTICAST: {
                message.setRoutingType(RoutingType.MULTICAST);
                break;
            }
            case STRIP: {
                message.setRoutingType(null);
                break;
            }
        }
        message.messageChanged();
        if (this.transformer != null) {
            Message transformedMessage = this.transformer.transform(message);
            if (transformedMessage != message) {
                logger.debug("The transformer {} made a copy of the message {} as transformedMessage", (Object)this.transformer, (Object)message);
            }
            return EmbedMessageUtil.embedAsCoreMessage(transformedMessage);
        }
        return EmbedMessageUtil.embedAsCoreMessage(message);
    }

    public void readyForWriting() {
        this.queue.deliverAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HandleStatus handle(MessageReference ref) throws Exception {
        if (RefCountMessage.isRefTraceEnabled() && ref.getMessage() instanceof RefCountMessage) {
            RefCountMessage.deferredDebug((Message)ref.getMessage(), (String)"Going through the bridge", (Object[])new Object[0]);
        }
        if (this.filter != null && !this.filter.match(ref.getMessage())) {
            logger.trace("message reference {} is no match for bridge {}", (Object)ref, (Object)this.configuration.getName());
            return HandleStatus.NO_MATCH;
        }
        BridgeImpl bridgeImpl = this;
        synchronized (bridgeImpl) {
            if (!this.active || !this.session.isWritable((ReadyListener)this)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("{}::Ignoring reference on bridge as it is set to inactive ref {}, active = {}", new Object[]{this, ref, this.active});
                }
                return HandleStatus.BUSY;
            }
            if (this.blockedOnFlowControl) {
                logger.debug("Bridge {} is blocked on flow control, cannot receive {}", (Object)this.configuration.getName(), (Object)ref);
                return HandleStatus.BUSY;
            }
            if (this.deliveringLargeMessage) {
                logger.trace("Bridge {} is busy delivering a large message", (Object)this.configuration.getName());
                return HandleStatus.BUSY;
            }
            logger.trace("Bridge {} is handling reference {} ", (Object)ref);
            ref.handled();
            Map<Long, MessageReference> map = this.refs;
            synchronized (map) {
                this.refs.put(ref.getMessage().getMessageID(), ref);
            }
            SimpleString dest = this.configuration.getForwardingAddress() != null ? SimpleString.of((String)this.configuration.getForwardingAddress()) : ref.getMessage().getAddressSimpleString();
            Message message = this.beforeForward(ref.getMessage(), dest);
            this.pendingAcks.countUp();
            try {
                HandleStatus status;
                if (this.server.hasBrokerBridgePlugins()) {
                    this.server.callBrokerBridgePlugins(plugin -> plugin.beforeDeliverBridge(this, ref));
                }
                if (message.isLargeMessage()) {
                    this.deliveringLargeMessage = true;
                    this.deliverLargeMessage(dest, ref, (LargeServerMessage)message, ref.getMessage());
                    status = HandleStatus.HANDLED;
                } else {
                    status = this.deliverStandardMessage(dest, ref, message, ref.getMessage());
                }
                if (status == HandleStatus.HANDLED) {
                    this.metrics.incrementMessagesPendingAcknowledgement();
                }
                if (this.server.hasBrokerBridgePlugins()) {
                    this.server.callBrokerBridgePlugins(plugin -> plugin.afterDeliverBridge(this, ref, status));
                }
                return status;
            }
            catch (Exception e) {
                this.pendingAcks.countDown();
                throw e;
            }
        }
    }

    @Override
    public void proceedDeliver(MessageReference ref) {
    }

    public void connectionFailed(ActiveMQException me, boolean failedOver) {
        this.connectionFailed(me, failedOver, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
        if (this.server.isStarted()) {
            if (me instanceof ActiveMQDisconnectedException) {
                ActiveMQServerLogger.LOGGER.bridgeConnectionClosed(failedOver);
            } else {
                ActiveMQServerLogger.LOGGER.bridgeConnectionFailed(failedOver);
            }
        }
        Object object = this.connectionGuard;
        synchronized (object) {
            this.keepConnecting = true;
        }
        try {
            if (this.producer != null) {
                this.producer.close();
            }
            BridgeImpl.cleanUpSessionFactory(this.csf);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.session.cleanUp(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (scaleDownTargetNodeID != null && !scaleDownTargetNodeID.equals(this.nodeUUID.toString())) {
            this.scaleDown(scaleDownTargetNodeID);
        } else if (scaleDownTargetNodeID != null) {
            logger.debug("Received scaleDownTargetNodeID: {}; cancelling reconnect.", (Object)scaleDownTargetNodeID);
            this.fail(true, true);
        } else {
            logger.debug("Received invalid scaleDownTargetNodeID: {}", (Object)scaleDownTargetNodeID);
            this.fail(me.getType() == ActiveMQExceptionType.DISCONNECTED, false);
        }
        this.tryScheduleRetryReconnect(me.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scaleDown(String scaleDownTargetNodeID) {
        BridgeImpl bridgeImpl = this;
        synchronized (bridgeImpl) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Moving {} messages from {} to {}", new Object[]{this.queue.getMessageCount(), this.queue.getName(), scaleDownTargetNodeID});
                }
                ((QueueImpl)this.queue).moveReferencesBetweenSnFQueues(SimpleString.of((String)scaleDownTargetNodeID));
                this.fail(true, true);
            }
            catch (Exception e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void tryScheduleRetryReconnect(ActiveMQExceptionType type) {
        this.scheduleRetryConnect();
    }

    public void beforeReconnect(ActiveMQException exception) {
    }

    private void deliverLargeMessage(final SimpleString dest, final MessageReference ref, final LargeServerMessage message, Message originalMessage) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    BridgeImpl.this.producer.send(dest, message.toMessage());
                    BridgeImpl.this.unsetLargeMessageDelivery();
                    if (BridgeImpl.this.queue != null) {
                        BridgeImpl.this.queue.deliverAsync();
                    }
                }
                catch (ActiveMQException e) {
                    BridgeImpl.this.unsetLargeMessageDelivery();
                    ActiveMQServerLogger.LOGGER.bridgeUnableToSendMessage(ref, (Exception)((Object)e));
                    BridgeImpl.this.connectionFailed(e, false);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HandleStatus deliverStandardMessage(SimpleString dest, MessageReference ref, Message message, Message originalMessage) {
        logger.trace("going to send message: {} from {}", (Object)message, (Object)this.queue);
        try {
            this.producer.send(dest, message);
        }
        catch (ActiveMQException e) {
            ActiveMQServerLogger.LOGGER.bridgeUnableToSendMessage(ref, (Exception)((Object)e));
            Object object = this.refs;
            synchronized (object) {
                this.refs.remove(message.getMessageID());
                ((QueueImpl)ref.getQueue()).decDelivering(ref);
            }
            this.connectionFailed(e, false);
            object = HandleStatus.BUSY;
            return object;
        }
        finally {
            originalMessage.usageDown();
        }
        return HandleStatus.HANDLED;
    }

    public TopologyMember getTargetNodeFromTopology() {
        return this.targetNode;
    }

    @Override
    public BridgeMetrics getMetrics() {
        return this.metrics;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + " [name=" + this.configuration.getName() + ", queue=" + this.queue + " targetConnector=" + this.serverLocator + "]";
    }

    @Override
    public String toManagementString() {
        return this.getClass().getSimpleName() + " [name=" + this.configuration.getName() + ", queue=" + this.queue.getName() + "/" + this.queue.getID() + "]";
    }

    public ClientSessionFactoryImpl getCSF() {
        return (ClientSessionFactoryImpl)this.csf;
    }

    public Transformer getTransformer() {
        return this.transformer;
    }

    @Override
    public BridgeConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void fail(boolean permanently, boolean scaleDown) {
        logger.debug("{}\n\t::fail being called, permanently={}", (Object)this, (Object)permanently);
        if (this.targetNodeID != null) {
            this.disconnectedAndDown = true;
            this.serverLocator.notifyNodeDown(System.currentTimeMillis(), this.targetNodeID);
        }
        if (this.queue != null) {
            try {
                logger.trace("Removing consumer on fail {} from queue {}", (Object)this, (Object)this.queue);
                this.queue.removeConsumer(this);
            }
            catch (Exception dontcare) {
                logger.debug(dontcare.getMessage(), (Throwable)dontcare);
            }
        }
        this.cancelRefs();
        if (this.queue != null) {
            this.queue.deliverAsync();
        }
    }

    protected void afterConnect() throws Exception {
        if (this.disconnectedAndDown && this.targetNodeID != null && this.targetNode != null) {
            this.serverLocator.notifyNodeUp(System.currentTimeMillis(), this.targetNodeID, this.targetNode.getBackupGroupName(), this.targetNode.getScaleDownGroupName(), new Pair((Object)this.targetNode.getPrimary(), (Object)this.targetNode.getBackup()), false);
            this.disconnectedAndDown = false;
        }
        this.retryCount = 0;
        this.reconnectAttemptsInUse = this.configuration.getReconnectAttempts();
        if (this.futureScheduledReconnection != null) {
            this.futureScheduledReconnection.cancel(true);
            this.futureScheduledReconnection = null;
        }
    }

    protected ClientSessionFactoryInternal createSessionFactory() throws Exception {
        if (this.targetNodeID != null && (this.configuration.getReconnectAttemptsOnSameNode() < 0 || this.retryCount <= this.configuration.getReconnectAttemptsOnSameNode())) {
            this.csf = this.reconnectOnOriginalNode();
        } else {
            this.serverLocator.resetToInitialConnectors();
            this.csf = (ClientSessionFactoryInternal)this.serverLocator.createSessionFactory();
        }
        if (this.csf != null) {
            this.csf.setReconnectAttempts(0);
        }
        return this.csf;
    }

    protected ClientSessionFactoryInternal reconnectOnOriginalNode() throws Exception {
        String targetNodeIdUse = this.targetNodeID;
        TopologyMember nodeUse = this.targetNode;
        if (targetNodeIdUse != null && nodeUse != null) {
            TransportConfiguration[] configs = new TransportConfiguration[2];
            int numberOfConfigs = 0;
            if (nodeUse.getPrimary() != null) {
                configs[numberOfConfigs++] = nodeUse.getPrimary();
            }
            if (nodeUse.getBackup() != null) {
                configs[numberOfConfigs++] = nodeUse.getBackup();
            }
            if (numberOfConfigs > 0) {
                int nodeTry = (this.retryCount - 1) % numberOfConfigs;
                return (ClientSessionFactoryInternal)this.serverLocator.createSessionFactory(configs[nodeTry]);
            }
        }
        return null;
    }

    protected void setSessionFactory(ClientSessionFactoryInternal sfi) {
        this.csf = sfi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void connect() {
        if (this.stopping) {
            return;
        }
        Object object = this.connectionGuard;
        synchronized (object) {
            if (!this.keepConnecting) {
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connecting  {} to its destination [{}], csf={}", new Object[]{this, this.nodeUUID, this.csf});
            }
            ++this.retryCount;
            try {
                if (this.csf == null || this.csf.isClosed()) {
                    if (this.stopping) {
                        return;
                    }
                    this.csf = this.createSessionFactory();
                    if (this.csf == null) {
                        this.scheduleRetryConnect();
                        return;
                    }
                    this.session = (ClientSessionInternal)this.csf.createSession(this.configuration.getUser(), this.configuration.getPassword(), false, true, true, true, 1);
                    this.session.getProducerCreditManager().setCallback((ClientProducerFlowCallback)this);
                    this.sessionConsumer = (ClientSessionInternal)this.csf.createSession(this.configuration.getUser(), this.configuration.getPassword(), false, true, true, true, 1);
                }
                if (this.configuration.getForwardingAddress() != null) {
                    ClientSession.AddressQuery query = null;
                    try {
                        query = this.session.addressQuery(SimpleString.of((String)this.configuration.getForwardingAddress()));
                    }
                    catch (Throwable e) {
                        ActiveMQServerLogger.LOGGER.errorQueryingBridge(this.configuration.getName(), e);
                        --this.retryCount;
                        this.scheduleRetryConnectFixedTimeout(100L);
                        return;
                    }
                    if (!query.isExists()) {
                        ActiveMQServerLogger.LOGGER.errorQueryingBridge(this.configuration.getForwardingAddress(), this.retryCount);
                        this.scheduleRetryConnect();
                        return;
                    }
                }
                this.blockedOnFlowControl = false;
                this.producer = this.session.createProducer();
                this.session.addFailureListener((SessionFailureListener)this);
                this.session.setSendAcknowledgementHandler((SendAcknowledgementHandler)this);
                this.afterConnect();
                this.active = true;
                this.queue.addConsumer(this);
                this.queue.deliverAsync();
                ActiveMQServerLogger.LOGGER.bridgeConnected(this);
                this.serverLocator.addClusterTopologyListener((ClusterTopologyListener)new TopologyListener());
                this.keepConnecting = false;
                return;
            }
            catch (ActiveMQException e) {
                if (e.getType() == ActiveMQExceptionType.SESSION_CREATION_REJECTED) {
                    ActiveMQServerLogger.LOGGER.errorStartingBridge(this.configuration.getName());
                    --this.retryCount;
                    this.scheduleRetryConnectFixedTimeout(this.configuration.getRetryInterval());
                    return;
                }
                ActiveMQServerLogger.LOGGER.errorConnectingBridgeRetry(this);
                logger.debug("Underlying bridge connection failure", (Throwable)e);
                this.scheduleRetryConnect();
            }
            catch (InterruptedException | ActiveMQInterruptedException e) {
                ActiveMQServerLogger.LOGGER.errorConnectingBridge(this, (Exception)e);
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorConnectingBridge(this, e);
                if (this.csf != null) {
                    try {
                        this.csf.close();
                        this.csf = null;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                this.fail(false, false);
                this.scheduleRetryConnect();
            }
        }
    }

    protected void scheduleRetryConnect() {
        if (this.serverLocator.isClosed()) {
            ActiveMQServerLogger.LOGGER.bridgeLocatorShutdown();
            return;
        }
        if (this.stopping) {
            ActiveMQServerLogger.LOGGER.bridgeStopping();
            return;
        }
        if (this.reconnectAttemptsInUse >= 0 && this.retryCount > this.reconnectAttemptsInUse) {
            ActiveMQServerLogger.LOGGER.bridgeAbortStart(this.configuration.getName(), this.retryCount, this.configuration.getReconnectAttempts());
            this.fail(true, false);
            return;
        }
        long timeout = (long)((double)this.configuration.getRetryInterval() * Math.pow(this.configuration.getRetryIntervalMultiplier(), this.retryCount));
        if (timeout == 0L) {
            timeout = this.configuration.getRetryInterval();
        }
        if (timeout > this.configuration.getMaxRetryInterval()) {
            timeout = this.configuration.getMaxRetryInterval();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Bridge {} retrying connection #{}, maxRetry={}, timeout={}", new Object[]{this, this.retryCount, this.reconnectAttemptsInUse, timeout});
        }
        this.scheduleRetryConnectFixedTimeout(timeout);
    }

    protected void nodeUP(TopologyMember member, boolean last) {
        if (member != null) {
            RemotingConnection connectionToUse;
            ClientSessionInternal sessionToUse = this.session;
            RemotingConnection remotingConnection = connectionToUse = sessionToUse != null ? sessionToUse.getConnection() : null;
            if (this.targetNodeID != null && this.targetNodeID.equals(member.getNodeId())) {
                this.targetNode = member;
            } else if (connectionToUse != null && member.isMember(connectionToUse)) {
                this.targetNode = member;
                this.targetNodeID = member.getNodeId();
            }
        }
    }

    protected void scheduleRetryConnectFixedTimeout(long milliseconds) {
        try {
            BridgeImpl.cleanUpSessionFactory(this.csf);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.stopping) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Scheduling retry for bridge {} in {} milliseconds", (Object)this.configuration.getName(), (Object)milliseconds);
        }
        this.futureScheduledReconnection = this.scheduledExecutor.schedule(new FutureConnectRunnable(this.executor, this), milliseconds, TimeUnit.MILLISECONDS);
    }

    private void internalCancelReferences() {
        this.cancelRefs();
        if (this.queue != null) {
            this.queue.deliverAsync();
        }
    }

    private synchronized void unsetLargeMessageDelivery() {
        this.deliveringLargeMessage = false;
    }

    private class TopologyListener
    implements ClusterTopologyListener {
        private TopologyListener() {
        }

        public void nodeUP(TopologyMember member, boolean last) {
            BridgeImpl.this.nodeUP(member, last);
        }

        public void nodeDown(long eventUID, String nodeID) {
        }
    }

    private class PauseRunnable
    implements Runnable {
        private PauseRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                BridgeImpl.this.queue.removeConsumer(BridgeImpl.this);
                if (!BridgeImpl.this.pendingAcks.await(60L, TimeUnit.SECONDS)) {
                    ActiveMQServerLogger.LOGGER.timedOutWaitingCompletions(BridgeImpl.this.toString(), BridgeImpl.this.pendingAcks.getCount());
                }
                BridgeImpl bridgeImpl = BridgeImpl.this;
                synchronized (bridgeImpl) {
                    BridgeImpl.this.started = false;
                    BridgeImpl.this.active = false;
                }
                BridgeImpl.this.internalCancelReferences();
                ActiveMQServerLogger.LOGGER.bridgePaused(BridgeImpl.this.configuration.getName());
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.errorPausingBridge(e);
            }
        }
    }

    private class StopRunnable
    implements Runnable {
        private StopRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.debug("stopping bridge {}", (Object)BridgeImpl.this);
            BridgeImpl.this.queue.removeConsumer(BridgeImpl.this);
            Object object = BridgeImpl.this;
            synchronized (object) {
                logger.debug("Closing Session for bridge {}", (Object)BridgeImpl.this.configuration.getName());
                BridgeImpl.this.started = false;
                BridgeImpl.this.active = false;
            }
            if (BridgeImpl.this.session != null) {
                logger.debug("Cleaning up session {}", (Object)BridgeImpl.this.session);
                BridgeImpl.this.session.removeFailureListener((SessionFailureListener)BridgeImpl.this);
                try {
                    BridgeImpl.this.session.close();
                    BridgeImpl.this.session = null;
                }
                catch (ActiveMQException activeMQException) {
                    // empty catch block
                }
            }
            if (BridgeImpl.this.sessionConsumer != null) {
                logger.debug("Cleaning up session {}", (Object)BridgeImpl.this.session);
                try {
                    BridgeImpl.this.sessionConsumer.close();
                    BridgeImpl.this.sessionConsumer = null;
                }
                catch (ActiveMQException activeMQException) {
                    // empty catch block
                }
            }
            BridgeImpl.this.internalCancelReferences();
            if (BridgeImpl.this.csf != null) {
                BridgeImpl.this.csf.cleanup();
            }
            object = BridgeImpl.this.connectionGuard;
            synchronized (object) {
                BridgeImpl.this.keepConnecting = true;
            }
            logger.trace("Removing consumer on stopRunnable {} from queue {}", (Object)this, (Object)BridgeImpl.this.queue);
            ActiveMQServerLogger.LOGGER.bridgeStopped(BridgeImpl.this.configuration.getName());
        }
    }

    private static final class ConnectRunnable
    implements Runnable {
        private final BridgeImpl bridge;

        private ConnectRunnable(BridgeImpl bridge2) {
            this.bridge = bridge2;
        }

        @Override
        public void run() {
            this.bridge.connect();
        }
    }

    private static class FutureConnectRunnable
    implements Runnable {
        private final BridgeImpl bridge;
        private final Executor executor;

        private FutureConnectRunnable(Executor exe, BridgeImpl bridge) {
            this.executor = exe;
            this.bridge = bridge;
        }

        @Override
        public void run() {
            if (this.bridge.isStarted()) {
                this.executor.execute(new ConnectRunnable(this.bridge));
            }
        }
    }
}

