/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.jms.client;

import jakarta.jms.BytesMessage;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.ExceptionListener;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.XAConnection;
import jakarta.jms.XASession;
import java.io.Serializable;
import javax.transaction.xa.XAResource;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionForContext;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSConsumer;
import org.apache.activemq.artemis.jms.client.ActiveMQJMSProducer;
import org.apache.activemq.artemis.jms.client.JmsExceptionUtils;
import org.apache.activemq.artemis.jms.client.ThreadAwareContext;

public class ActiveMQJMSContext
implements JMSContext {
    private static final boolean DEFAULT_AUTO_START = true;
    private final int sessionMode;
    private final ThreadAwareContext threadAwareContext;
    private volatile Message lastMessagesWaitingAck;
    private final ActiveMQConnectionForContext connection;
    private volatile Session session;
    private boolean autoStart = true;
    private MessageProducer innerProducer;
    private boolean xa;
    private boolean closed;

    ActiveMQJMSContext(ActiveMQConnectionForContext connection, int ackMode, boolean xa, ThreadAwareContext threadAwareContext) {
        this.connection = connection;
        this.sessionMode = ackMode;
        this.xa = xa;
        this.threadAwareContext = threadAwareContext;
    }

    public ActiveMQJMSContext(ActiveMQConnectionForContext connection, int ackMode, ThreadAwareContext threadAwareContext) {
        this(connection, ackMode, false, threadAwareContext);
    }

    public ActiveMQJMSContext(ActiveMQConnectionForContext connection, ThreadAwareContext threadAwareContext) {
        this(connection, 0, true, threadAwareContext);
    }

    public JMSContext getContext() {
        return this;
    }

    public Session getSession() {
        this.checkSession();
        return this.session;
    }

    public XAResource getXAResource() {
        this.checkSession();
        return ((XASession)this.session).getXAResource();
    }

    public JMSContext createContext(int sessionMode) {
        return this.connection.createContext(sessionMode);
    }

    public JMSProducer createProducer() {
        this.checkSession();
        try {
            return new ActiveMQJMSProducer(this, this.getInnerProducer());
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    private synchronized MessageProducer getInnerProducer() throws JMSException {
        if (this.innerProducer == null) {
            this.innerProducer = this.session.createProducer(null);
        }
        return this.innerProducer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSession() {
        if (this.session == null) {
            ActiveMQJMSContext activeMQJMSContext = this;
            synchronized (activeMQJMSContext) {
                if (this.closed) {
                    throw new IllegalStateRuntimeException("Context is closed");
                }
                if (this.session == null) {
                    try {
                        this.session = this.xa ? ((XAConnection)this.connection).createXASession() : this.connection.createSession(this.sessionMode);
                    }
                    catch (JMSException e) {
                        throw JmsExceptionUtils.convertToRuntimeException(e);
                    }
                }
            }
        }
    }

    public String getClientID() {
        try {
            return this.connection.getClientID();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public void setClientID(String clientID) {
        try {
            this.connection.setClientID(clientID);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public ConnectionMetaData getMetaData() {
        try {
            return this.connection.getMetaData();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public ExceptionListener getExceptionListener() {
        try {
            return this.connection.getExceptionListener();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public void setExceptionListener(ExceptionListener listener) {
        try {
            this.connection.setExceptionListener(listener);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public void start() {
        try {
            this.connection.start();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public void stop() {
        this.threadAwareContext.assertNotMessageListenerThreadRuntime();
        try {
            this.connection.stop();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public boolean getAutoStart() {
        return this.autoStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.threadAwareContext.assertNotCompletionListenerThreadRuntime();
        this.threadAwareContext.assertNotMessageListenerThreadRuntime();
        try {
            ActiveMQJMSContext activeMQJMSContext = this;
            synchronized (activeMQJMSContext) {
                if (this.session != null) {
                    this.session.close();
                }
                this.connection.closeFromContext();
                this.closed = true;
            }
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public BytesMessage createBytesMessage() {
        this.checkSession();
        try {
            return this.session.createBytesMessage();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public MapMessage createMapMessage() {
        this.checkSession();
        try {
            return this.session.createMapMessage();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public Message createMessage() {
        this.checkSession();
        try {
            return this.session.createMessage();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public ObjectMessage createObjectMessage() {
        this.checkSession();
        try {
            return this.session.createObjectMessage();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public ObjectMessage createObjectMessage(Serializable object) {
        this.checkSession();
        try {
            return this.session.createObjectMessage(object);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public StreamMessage createStreamMessage() {
        this.checkSession();
        try {
            return this.session.createStreamMessage();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public TextMessage createTextMessage() {
        this.checkSession();
        try {
            return this.session.createTextMessage();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public TextMessage createTextMessage(String text) {
        this.checkSession();
        try {
            return this.session.createTextMessage(text);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public boolean getTransacted() {
        this.checkSession();
        try {
            return this.session.getTransacted();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public int getSessionMode() {
        return this.sessionMode;
    }

    public void commit() {
        this.threadAwareContext.assertNotCompletionListenerThreadRuntime();
        this.checkSession();
        try {
            this.session.commit();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public void rollback() {
        this.threadAwareContext.assertNotCompletionListenerThreadRuntime();
        this.checkSession();
        try {
            this.session.rollback();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public void recover() {
        this.checkSession();
        try {
            this.session.recover();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createConsumer(Destination destination) {
        this.checkSession();
        try {
            ActiveMQJMSConsumer consumer = new ActiveMQJMSConsumer(this, this.session.createConsumer(destination));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector) {
        this.checkSession();
        try {
            ActiveMQJMSConsumer consumer = new ActiveMQJMSConsumer(this, this.session.createConsumer(destination, messageSelector));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createConsumer(Destination destination, String messageSelector, boolean noLocal) {
        this.checkSession();
        try {
            ActiveMQJMSConsumer consumer = new ActiveMQJMSConsumer(this, this.session.createConsumer(destination, messageSelector, noLocal));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public Queue createQueue(String queueName) {
        this.checkSession();
        try {
            return this.session.createQueue(queueName);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public Topic createTopic(String topicName) {
        this.checkSession();
        try {
            return this.session.createTopic(topicName);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name) {
        this.checkSession();
        try {
            ActiveMQJMSConsumer consumer = new ActiveMQJMSConsumer(this, this.session.createDurableConsumer(topic, name));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createDurableConsumer(Topic topic, String name, String messageSelector, boolean noLocal) {
        this.checkSession();
        try {
            ActiveMQJMSConsumer consumer = new ActiveMQJMSConsumer(this, this.session.createDurableConsumer(topic, name, messageSelector, noLocal));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name) {
        this.checkSession();
        try {
            ActiveMQJMSConsumer consumer = new ActiveMQJMSConsumer(this, this.session.createSharedDurableConsumer(topic, name));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createSharedDurableConsumer(Topic topic, String name, String messageSelector) {
        this.checkSession();
        try {
            ActiveMQJMSConsumer consumer = new ActiveMQJMSConsumer(this, this.session.createSharedDurableConsumer(topic, name, messageSelector));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName) {
        this.checkSession();
        try {
            ActiveMQJMSConsumer consumer = new ActiveMQJMSConsumer(this, this.session.createSharedConsumer(topic, sharedSubscriptionName));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public JMSConsumer createSharedConsumer(Topic topic, String sharedSubscriptionName, String messageSelector) {
        this.checkSession();
        try {
            ActiveMQJMSConsumer consumer = new ActiveMQJMSConsumer(this, this.session.createSharedConsumer(topic, sharedSubscriptionName, messageSelector));
            this.checkAutoStart();
            return consumer;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public QueueBrowser createBrowser(Queue queue) {
        this.checkSession();
        try {
            QueueBrowser browser = this.session.createBrowser(queue);
            this.checkAutoStart();
            return browser;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) {
        this.checkSession();
        try {
            QueueBrowser browser = this.session.createBrowser(queue, messageSelector);
            this.checkAutoStart();
            return browser;
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public TemporaryQueue createTemporaryQueue() {
        this.checkSession();
        try {
            return this.session.createTemporaryQueue();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public TemporaryTopic createTemporaryTopic() {
        this.checkSession();
        try {
            return this.session.createTemporaryTopic();
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public void unsubscribe(String name) {
        this.checkSession();
        try {
            this.session.unsubscribe(name);
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public void acknowledge() {
        this.checkSession();
        if (this.closed) {
            throw new IllegalStateRuntimeException("Context is closed");
        }
        try {
            if (this.lastMessagesWaitingAck != null) {
                this.lastMessagesWaitingAck.acknowledge();
            }
        }
        catch (JMSException e) {
            throw JmsExceptionUtils.convertToRuntimeException(e);
        }
    }

    public Session getUsedSession() {
        return this.session;
    }

    private synchronized void checkAutoStart() throws JMSException {
        if (this.closed) {
            throw new IllegalStateRuntimeException("Context is closed");
        }
        if (this.autoStart) {
            this.connection.start();
        }
    }

    Message setLastMessage(JMSConsumer consumer, Message lastMessageReceived) {
        if (this.sessionMode == 2) {
            this.lastMessagesWaitingAck = lastMessageReceived;
        }
        return lastMessageReceived;
    }

    public ThreadAwareContext getThreadAwareContext() {
        return this.threadAwareContext;
    }
}

