/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.httpsignature.filters;

import java.io.IOException;
import java.io.InputStream;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.rs.security.httpsignature.DigestVerifier;
import org.apache.cxf.rs.security.httpsignature.MessageVerifier;
import org.apache.cxf.rs.security.httpsignature.exception.DifferentAlgorithmsException;
import org.apache.cxf.rs.security.httpsignature.exception.DifferentDigestsException;
import org.apache.cxf.rs.security.httpsignature.exception.DigestFailureException;
import org.apache.cxf.rs.security.httpsignature.exception.InvalidDataToVerifySignatureException;
import org.apache.cxf.rs.security.httpsignature.exception.InvalidSignatureException;
import org.apache.cxf.rs.security.httpsignature.exception.InvalidSignatureHeaderException;
import org.apache.cxf.rs.security.httpsignature.exception.MissingDigestException;
import org.apache.cxf.rs.security.httpsignature.exception.MissingSignatureHeaderException;
import org.apache.cxf.rs.security.httpsignature.exception.MultipleSignatureHeaderException;
import org.apache.cxf.rs.security.httpsignature.exception.SignatureException;
import org.apache.cxf.rs.security.httpsignature.utils.KeyManagementUtils;

abstract class AbstractSignatureInFilter {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractSignatureInFilter.class);
    private MessageVerifier messageVerifier;
    private boolean enabled = true;

    AbstractSignatureInFilter() {
    }

    protected byte[] verifyDigest(MultivaluedMap<String, String> headers, InputStream entityStream) {
        byte[] messageBody = null;
        if (!this.enabled) {
            return messageBody;
        }
        if (entityStream != null && headers.containsKey((Object)"Digest")) {
            LOG.fine("Digesting message body");
            try {
                messageBody = IOUtils.readBytesFromStream((InputStream)entityStream);
            }
            catch (IOException e) {
                throw new DigestFailureException("failed to validate the digest", e);
            }
            DigestVerifier digestVerifier = new DigestVerifier();
            try {
                digestVerifier.inspectDigest(messageBody, (Map<String, List<String>>)headers);
            }
            catch (DifferentDigestsException | DigestFailureException | MissingDigestException ex) {
                Message message = PhaseInterceptorChain.getCurrentMessage();
                if (MessageUtils.isRequestor((Message)message)) {
                    throw ex;
                }
                throw new BadRequestException((Throwable)ex);
            }
        }
        LOG.fine("Finished digest message verification process");
        return messageBody;
    }

    protected void verifySignature(MultivaluedMap<String, String> headers, String uriPath, String httpMethod, byte[] messageBody) {
        if (!this.enabled) {
            LOG.fine("Verify signature filter is disabled");
            return;
        }
        if (this.messageVerifier == null) {
            this.messageVerifier = this.createMessageVerifier();
        }
        LOG.fine("Starting filter message verification process");
        try {
            this.messageVerifier.verifyMessage((Map<String, List<String>>)headers, httpMethod, uriPath, PhaseInterceptorChain.getCurrentMessage(), messageBody);
        }
        catch (DifferentAlgorithmsException | InvalidDataToVerifySignatureException | InvalidSignatureException | InvalidSignatureHeaderException | MissingSignatureHeaderException | MultipleSignatureHeaderException ex) {
            LOG.warning(ex.getMessage());
            this.handleException(ex);
        }
        LOG.fine("Finished filter message verification process");
    }

    public void setMessageVerifier(MessageVerifier messageVerifier) {
        Objects.requireNonNull(messageVerifier);
        this.messageVerifier = messageVerifier;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected MessageVerifier createMessageVerifier() {
        Properties props = KeyManagementUtils.loadSignatureInProperties();
        if (props == null) {
            throw new SignatureException("Signature properties are not configured correctly");
        }
        Message m = PhaseInterceptorChain.getCurrentMessage();
        PublicKey publicKey = KeyManagementUtils.loadPublicKey(m, props);
        String signatureAlgorithm = (String)m.getContextualProperty("rs.security.signature.algorithm");
        if (signatureAlgorithm == null) {
            signatureAlgorithm = "rsa-sha256";
        }
        String finalSignatureAlgorithm = signatureAlgorithm;
        Provider provider = Security.getProvider("SunRsaSign");
        return new MessageVerifier(keyId -> publicKey, keyId -> provider, keyId -> finalSignatureAlgorithm);
    }

    protected abstract void handleException(Exception var1);
}

