/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwa;

import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;

public enum ContentAlgorithm {
    A128GCM("A128GCM", "AES/GCM/NoPadding", 128),
    A192GCM("A192GCM", "AES/GCM/NoPadding", 192),
    A256GCM("A256GCM", "AES/GCM/NoPadding", 256),
    A128CBC_HS256("A128CBC-HS256", "AES/CBC/PKCS7Padding", 128),
    A192CBC_HS384("A192CBC-HS384", "AES/CBC/PKCS7Padding", 192),
    A256CBC_HS512("A256CBC-HS512", "AES/CBC/PKCS7Padding", 256);

    private final String jwaName;
    private final String javaName;
    private final int keySizeBits;

    private ContentAlgorithm(String jwaName, String javaName, int keySizeBits) {
        this.jwaName = jwaName;
        this.javaName = javaName;
        this.keySizeBits = keySizeBits;
    }

    public String getJwaName() {
        return this.jwaName;
    }

    public String getJavaName() {
        return this.javaName == null ? this.name() : this.javaName;
    }

    public String getJavaAlgoName() {
        return AlgorithmUtils.stripAlgoProperties(this.getJavaName());
    }

    public int getKeySizeBits() {
        return this.keySizeBits;
    }

    public static ContentAlgorithm getAlgorithm(String algo) {
        if (algo == null) {
            return null;
        }
        return ContentAlgorithm.valueOf(algo.replace('-', '_').replace('+', '_'));
    }
}

