/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.hdfs;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.vfs2.provider.AbstractRandomAccessContent;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HdfsRandomAccessContent
extends AbstractRandomAccessContent {
    private final FSDataInputStream fis;
    private final FileSystem fs;
    private final Path path;

    public HdfsRandomAccessContent(Path path, FileSystem fs) throws IOException {
        super(RandomAccessMode.READ);
        this.fs = fs;
        this.path = path;
        this.fis = this.fs.open(this.path);
    }

    public void close() throws IOException {
        this.fis.close();
    }

    public long getFilePointer() throws IOException {
        return this.fis.getPos();
    }

    public InputStream getInputStream() throws IOException {
        return this.fis;
    }

    public long length() throws IOException {
        return this.fs.getFileStatus(this.path).getLen();
    }

    public boolean readBoolean() throws IOException {
        return this.fis.readBoolean();
    }

    public byte readByte() throws IOException {
        return this.fis.readByte();
    }

    public char readChar() throws IOException {
        return this.fis.readChar();
    }

    public double readDouble() throws IOException {
        return this.fis.readDouble();
    }

    public float readFloat() throws IOException {
        return this.fis.readFloat();
    }

    public void readFully(byte[] b) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int readInt() throws IOException {
        return this.fis.readInt();
    }

    public String readLine() throws IOException {
        return this.fis.readLine();
    }

    public long readLong() throws IOException {
        return this.fis.readLong();
    }

    public short readShort() throws IOException {
        return this.fis.readShort();
    }

    public int readUnsignedByte() throws IOException {
        return this.fis.readUnsignedByte();
    }

    public int readUnsignedShort() throws IOException {
        return this.fis.readUnsignedShort();
    }

    public String readUTF() throws IOException {
        return this.fis.readUTF();
    }

    public void seek(long pos) throws IOException {
        this.fis.seek(pos);
    }

    public void setLength(long newLength) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int skipBytes(int n) throws IOException {
        throw new UnsupportedOperationException();
    }
}

