/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.descriptive;

import org.apache.commons.math4.legacy.core.MathArrays;
import org.apache.commons.math4.legacy.exception.MathIllegalArgumentException;
import org.apache.commons.math4.legacy.exception.NullArgumentException;
import org.apache.commons.math4.legacy.exception.util.Localizable;
import org.apache.commons.math4.legacy.exception.util.LocalizedFormats;
import org.apache.commons.math4.legacy.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.numbers.core.Precision;

public abstract class AbstractStorelessUnivariateStatistic
implements StorelessUnivariateStatistic {
    @Override
    public double evaluate(double[] values) throws MathIllegalArgumentException {
        if (values == null) {
            throw new NullArgumentException((Localizable)LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        return this.evaluate(values, 0, values.length);
    }

    @Override
    public double evaluate(double[] values, int begin, int length) throws MathIllegalArgumentException {
        if (MathArrays.verifyValues((double[])values, (int)begin, (int)length)) {
            StorelessUnivariateStatistic stat = this.copy();
            stat.clear();
            stat.incrementAll(values, begin, length);
            return stat.getResult();
        }
        return Double.NaN;
    }

    @Override
    public abstract StorelessUnivariateStatistic copy();

    @Override
    public abstract void clear();

    @Override
    public abstract double getResult();

    @Override
    public abstract void increment(double var1);

    @Override
    public void incrementAll(double[] values) throws MathIllegalArgumentException {
        if (values == null) {
            throw new NullArgumentException((Localizable)LocalizedFormats.INPUT_ARRAY, new Object[0]);
        }
        this.incrementAll(values, 0, values.length);
    }

    @Override
    public void incrementAll(double[] values, int begin, int length) throws MathIllegalArgumentException {
        if (MathArrays.verifyValues((double[])values, (int)begin, (int)length)) {
            int k = begin + length;
            for (int i = begin; i < k; ++i) {
                this.increment(values[i]);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        StorelessUnivariateStatistic stat = (StorelessUnivariateStatistic)object;
        return Precision.equalsIncludingNaN((double)stat.getResult(), (double)this.getResult()) && Precision.equalsIncludingNaN((float)stat.getN(), (float)this.getN());
    }

    public int hashCode() {
        return 31 * (31 + Double.hashCode(this.getResult())) + Double.hashCode(this.getN());
    }
}

