/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math4.legacy.stat.interval;

import org.apache.commons.math4.legacy.stat.interval.BinomialConfidenceInterval;
import org.apache.commons.math4.legacy.stat.interval.ConfidenceInterval;
import org.apache.commons.math4.legacy.stat.interval.IntervalUtils;
import org.apache.commons.statistics.distribution.FDistribution;

public class ClopperPearsonInterval
implements BinomialConfidenceInterval {
    @Override
    public ConfidenceInterval createInterval(int numberOfTrials, int numberOfSuccesses, double confidenceLevel) {
        IntervalUtils.checkParameters(numberOfTrials, numberOfSuccesses, confidenceLevel);
        double lowerBound = 0.0;
        double upperBound = 1.0;
        double alpha = 0.5 * (1.0 - confidenceLevel);
        if (numberOfSuccesses > 0) {
            FDistribution distributionLowerBound = FDistribution.of((double)(2.0 * (double)(numberOfTrials - numberOfSuccesses + 1)), (double)(2.0 * (double)numberOfSuccesses));
            double fValueLowerBound = distributionLowerBound.inverseSurvivalProbability(alpha);
            lowerBound = (double)numberOfSuccesses / ((double)numberOfSuccesses + (double)(numberOfTrials - numberOfSuccesses + 1) * fValueLowerBound);
        }
        if (numberOfSuccesses < numberOfTrials) {
            FDistribution distributionUpperBound = FDistribution.of((double)(2.0 * (double)(numberOfSuccesses + 1)), (double)(2.0 * (double)(numberOfTrials - numberOfSuccesses)));
            double fValueUpperBound = distributionUpperBound.inverseSurvivalProbability(alpha);
            upperBound = (double)(numberOfSuccesses + 1) * fValueUpperBound / ((double)(numberOfTrials - numberOfSuccesses) + (double)(numberOfSuccesses + 1) * fValueUpperBound);
        }
        return new ConfidenceInterval(lowerBound, upperBound, confidenceLevel);
    }
}

