/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.linear;

import org.apache.commons.math3.TestUtils;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.apache.commons.math3.exception.OutOfRangeException;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.DiagonalMatrix;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularMatrixException;
import org.apache.commons.math3.util.Precision;
import org.junit.Assert;
import org.junit.Test;

public class DiagonalMatrixTest {
    @Test
    public void testConstructor1() {
        int dim = 3;
        DiagonalMatrix m = new DiagonalMatrix(3);
        Assert.assertEquals((long)3L, (long)m.getRowDimension());
        Assert.assertEquals((long)3L, (long)m.getColumnDimension());
    }

    @Test
    public void testConstructor2() {
        double[] d = new double[]{-1.2, 3.4, 5.0};
        DiagonalMatrix m = new DiagonalMatrix(d);
        for (int i = 0; i < m.getRowDimension(); ++i) {
            for (int j = 0; j < m.getRowDimension(); ++j) {
                if (i == j) {
                    Assert.assertEquals((double)d[i], (double)m.getEntry(i, j), (double)0.0);
                    continue;
                }
                Assert.assertEquals((double)0.0, (double)m.getEntry(i, j), (double)0.0);
            }
        }
        d[0] = 0.0;
        Assert.assertFalse((d[0] == m.getEntry(0, 0) ? 1 : 0) != 0);
    }

    @Test
    public void testConstructor3() {
        double[] d = new double[]{-1.2, 3.4, 5.0};
        DiagonalMatrix m = new DiagonalMatrix(d, false);
        for (int i = 0; i < m.getRowDimension(); ++i) {
            for (int j = 0; j < m.getRowDimension(); ++j) {
                if (i == j) {
                    Assert.assertEquals((double)d[i], (double)m.getEntry(i, j), (double)0.0);
                    continue;
                }
                Assert.assertEquals((double)0.0, (double)m.getEntry(i, j), (double)0.0);
            }
        }
        d[0] = 0.0;
        Assert.assertTrue((d[0] == m.getEntry(0, 0) ? 1 : 0) != 0);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testCreateError() {
        double[] d = new double[]{-1.2, 3.4, 5.0};
        DiagonalMatrix m = new DiagonalMatrix(d, false);
        m.createMatrix(5, 3);
    }

    @Test
    public void testCreate() {
        double[] d = new double[]{-1.2, 3.4, 5.0};
        DiagonalMatrix m = new DiagonalMatrix(d, false);
        RealMatrix p = m.createMatrix(5, 5);
        Assert.assertTrue((boolean)(p instanceof DiagonalMatrix));
        Assert.assertEquals((long)5L, (long)p.getRowDimension());
        Assert.assertEquals((long)5L, (long)p.getColumnDimension());
    }

    @Test
    public void testCopy() {
        double[] d = new double[]{-1.2, 3.4, 5.0};
        DiagonalMatrix m = new DiagonalMatrix(d, false);
        DiagonalMatrix p = (DiagonalMatrix)m.copy();
        for (int i = 0; i < m.getRowDimension(); ++i) {
            Assert.assertEquals((double)m.getEntry(i, i), (double)p.getEntry(i, i), (double)1.0E-20);
        }
    }

    @Test
    public void testGetData() {
        double[] data = new double[]{-1.2, 3.4, 5.0};
        int dim = 3;
        DiagonalMatrix m = new DiagonalMatrix(3);
        for (int i = 0; i < 3; ++i) {
            m.setEntry(i, i, data[i]);
        }
        double[][] out = m.getData();
        Assert.assertEquals((long)3L, (long)out.length);
        for (int i = 0; i < m.getRowDimension(); ++i) {
            Assert.assertEquals((long)3L, (long)out[i].length);
            for (int j = 0; j < m.getRowDimension(); ++j) {
                if (i == j) {
                    Assert.assertEquals((double)data[i], (double)out[i][j], (double)0.0);
                    continue;
                }
                Assert.assertEquals((double)0.0, (double)out[i][j], (double)0.0);
            }
        }
    }

    @Test
    public void testAdd() {
        double[] data1 = new double[]{-1.2, 3.4, 5.0};
        DiagonalMatrix m1 = new DiagonalMatrix(data1);
        double[] data2 = new double[]{10.1, 2.3, 45.0};
        DiagonalMatrix m2 = new DiagonalMatrix(data2);
        DiagonalMatrix result = m1.add(m2);
        Assert.assertEquals((long)m1.getRowDimension(), (long)result.getRowDimension());
        for (int i = 0; i < result.getRowDimension(); ++i) {
            for (int j = 0; j < result.getRowDimension(); ++j) {
                if (i == j) {
                    Assert.assertEquals((double)(data1[i] + data2[i]), (double)result.getEntry(i, j), (double)0.0);
                    continue;
                }
                Assert.assertEquals((double)0.0, (double)result.getEntry(i, j), (double)0.0);
            }
        }
    }

    @Test
    public void testSubtract() {
        double[] data1 = new double[]{-1.2, 3.4, 5.0};
        DiagonalMatrix m1 = new DiagonalMatrix(data1);
        double[] data2 = new double[]{10.1, 2.3, 45.0};
        DiagonalMatrix m2 = new DiagonalMatrix(data2);
        DiagonalMatrix result = m1.subtract(m2);
        Assert.assertEquals((long)m1.getRowDimension(), (long)result.getRowDimension());
        for (int i = 0; i < result.getRowDimension(); ++i) {
            for (int j = 0; j < result.getRowDimension(); ++j) {
                if (i == j) {
                    Assert.assertEquals((double)(data1[i] - data2[i]), (double)result.getEntry(i, j), (double)0.0);
                    continue;
                }
                Assert.assertEquals((double)0.0, (double)result.getEntry(i, j), (double)0.0);
            }
        }
    }

    @Test
    public void testAddToEntry() {
        double[] data = new double[]{-1.2, 3.4, 5.0};
        DiagonalMatrix m = new DiagonalMatrix(data);
        for (int i = 0; i < m.getRowDimension(); ++i) {
            m.addToEntry(i, i, (double)i);
            Assert.assertEquals((double)(data[i] + (double)i), (double)m.getEntry(i, i), (double)0.0);
        }
    }

    @Test
    public void testMultiplyEntry() {
        double[] data = new double[]{-1.2, 3.4, 5.0};
        DiagonalMatrix m = new DiagonalMatrix(data);
        for (int i = 0; i < m.getRowDimension(); ++i) {
            m.multiplyEntry(i, i, (double)i);
            Assert.assertEquals((double)(data[i] * (double)i), (double)m.getEntry(i, i), (double)0.0);
        }
    }

    @Test
    public void testMultiply1() {
        double[] data1 = new double[]{-1.2, 3.4, 5.0};
        DiagonalMatrix m1 = new DiagonalMatrix(data1);
        double[] data2 = new double[]{10.1, 2.3, 45.0};
        DiagonalMatrix m2 = new DiagonalMatrix(data2);
        DiagonalMatrix result = (DiagonalMatrix)m1.multiply((RealMatrix)m2);
        Assert.assertEquals((long)m1.getRowDimension(), (long)result.getRowDimension());
        for (int i = 0; i < result.getRowDimension(); ++i) {
            for (int j = 0; j < result.getRowDimension(); ++j) {
                if (i == j) {
                    Assert.assertEquals((double)(data1[i] * data2[i]), (double)result.getEntry(i, j), (double)0.0);
                    continue;
                }
                Assert.assertEquals((double)0.0, (double)result.getEntry(i, j), (double)0.0);
            }
        }
    }

    @Test
    public void testMultiply2() {
        double[] data1 = new double[]{-1.2, 3.4, 5.0};
        DiagonalMatrix diag1 = new DiagonalMatrix(data1);
        double[][] data2 = new double[][]{{-1.2, 3.4}, {-5.6, 7.8}, {9.1, 2.3}};
        Array2DRowRealMatrix dense2 = new Array2DRowRealMatrix((double[][])data2);
        Array2DRowRealMatrix dense1 = new Array2DRowRealMatrix(diag1.getData());
        RealMatrix diagResult = diag1.multiply((RealMatrix)dense2);
        RealMatrix denseResult = dense1.multiply((RealMatrix)dense2);
        for (int i = 0; i < dense1.getRowDimension(); ++i) {
            for (int j = 0; j < dense2.getColumnDimension(); ++j) {
                Assert.assertEquals((double)denseResult.getEntry(i, j), (double)diagResult.getEntry(i, j), (double)0.0);
            }
        }
    }

    @Test
    public void testOperate() {
        double[] data = new double[]{-1.2, 3.4, 5.0};
        DiagonalMatrix diag = new DiagonalMatrix(data);
        Array2DRowRealMatrix dense = new Array2DRowRealMatrix(diag.getData());
        double[] v = new double[]{6.7, 890.1, 23.4};
        double[] diagResult = diag.operate(v);
        double[] denseResult = dense.operate(v);
        TestUtils.assertEquals(diagResult, denseResult, 0.0);
    }

    @Test
    public void testPreMultiply() {
        double[] data = new double[]{-1.2, 3.4, 5.0};
        DiagonalMatrix diag = new DiagonalMatrix(data);
        Array2DRowRealMatrix dense = new Array2DRowRealMatrix(diag.getData());
        double[] v = new double[]{6.7, 890.1, 23.4};
        double[] diagResult = diag.preMultiply(v);
        double[] denseResult = dense.preMultiply(v);
        TestUtils.assertEquals(diagResult, denseResult, 0.0);
    }

    @Test
    public void testPreMultiplyVector() {
        double[] data = new double[]{-1.2, 3.4, 5.0};
        DiagonalMatrix diag = new DiagonalMatrix(data);
        Array2DRowRealMatrix dense = new Array2DRowRealMatrix(diag.getData());
        double[] v = new double[]{6.7, 890.1, 23.4};
        RealVector vector = MatrixUtils.createRealVector((double[])v);
        RealVector diagResult = diag.preMultiply(vector);
        RealVector denseResult = dense.preMultiply(vector);
        TestUtils.assertEquals("preMultiply(Vector) returns wrong result", diagResult, denseResult, 0.0);
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testSetNonDiagonalEntry() {
        DiagonalMatrix diag = new DiagonalMatrix(3);
        diag.setEntry(1, 2, 3.4);
    }

    @Test
    public void testSetNonDiagonalZero() {
        DiagonalMatrix diag = new DiagonalMatrix(3);
        diag.setEntry(1, 2, 0.0);
        Assert.assertEquals((double)0.0, (double)diag.getEntry(1, 2), (double)Precision.SAFE_MIN);
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testAddNonDiagonalEntry() {
        DiagonalMatrix diag = new DiagonalMatrix(3);
        diag.addToEntry(1, 2, 3.4);
    }

    @Test
    public void testAddNonDiagonalZero() {
        DiagonalMatrix diag = new DiagonalMatrix(3);
        diag.addToEntry(1, 2, 0.0);
        Assert.assertEquals((double)0.0, (double)diag.getEntry(1, 2), (double)Precision.SAFE_MIN);
    }

    @Test
    public void testMultiplyNonDiagonalEntry() {
        DiagonalMatrix diag = new DiagonalMatrix(3);
        diag.multiplyEntry(1, 2, 3.4);
        Assert.assertEquals((double)0.0, (double)diag.getEntry(1, 2), (double)Precision.SAFE_MIN);
    }

    @Test
    public void testMultiplyNonDiagonalZero() {
        DiagonalMatrix diag = new DiagonalMatrix(3);
        diag.multiplyEntry(1, 2, 0.0);
        Assert.assertEquals((double)0.0, (double)diag.getEntry(1, 2), (double)Precision.SAFE_MIN);
    }

    @Test(expected=OutOfRangeException.class)
    public void testSetEntryOutOfRange() {
        DiagonalMatrix diag = new DiagonalMatrix(3);
        diag.setEntry(3, 3, 3.4);
    }

    @Test(expected=NullArgumentException.class)
    public void testNull() {
        new DiagonalMatrix(null, false);
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testSetSubMatrixError() {
        double[] data = new double[]{-1.2, 3.4, 5.0};
        DiagonalMatrix diag = new DiagonalMatrix(data);
        diag.setSubMatrix((double[][])new double[][]{{1.0, 1.0}, {1.0, 1.0}}, 1, 1);
    }

    @Test
    public void testSetSubMatrix() {
        double[] data = new double[]{-1.2, 3.4, 5.0};
        DiagonalMatrix diag = new DiagonalMatrix(data);
        diag.setSubMatrix((double[][])new double[][]{{0.0, 5.0, 0.0}, {0.0, 0.0, 6.0}}, 1, 0);
        Assert.assertEquals((double)-1.2, (double)diag.getEntry(0, 0), (double)1.0E-20);
        Assert.assertEquals((double)5.0, (double)diag.getEntry(1, 1), (double)1.0E-20);
        Assert.assertEquals((double)6.0, (double)diag.getEntry(2, 2), (double)1.0E-20);
    }

    @Test(expected=SingularMatrixException.class)
    public void testInverseError() {
        double[] data = new double[]{1.0, 2.0, 0.0};
        DiagonalMatrix diag = new DiagonalMatrix(data);
        diag.inverse();
    }

    @Test(expected=SingularMatrixException.class)
    public void testInverseError2() {
        double[] data = new double[]{1.0, 2.0, 1.0E-6};
        DiagonalMatrix diag = new DiagonalMatrix(data);
        diag.inverse(1.0E-5);
    }

    @Test
    public void testInverse() {
        double[] data = new double[]{1.0, 2.0, 3.0};
        DiagonalMatrix m = new DiagonalMatrix(data);
        DiagonalMatrix inverse = m.inverse();
        DiagonalMatrix result = m.multiply(inverse);
        TestUtils.assertEquals("DiagonalMatrix.inverse() returns wrong result", MatrixUtils.createRealIdentityMatrix((int)data.length), (RealMatrix)result, Math.ulp(1.0));
    }
}

