/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote.http.client;

import java.util.function.Supplier;
import org.apache.commons.jcs3.auxiliary.AbstractAuxiliaryCacheFactory;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCache;
import org.apache.commons.jcs3.auxiliary.AuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.RemoteCacheNoWait;
import org.apache.commons.jcs3.auxiliary.remote.http.client.RemoteHttpCache;
import org.apache.commons.jcs3.auxiliary.remote.http.client.RemoteHttpCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.http.client.RemoteHttpCacheClient;
import org.apache.commons.jcs3.auxiliary.remote.http.client.RemoteHttpCacheMonitor;
import org.apache.commons.jcs3.auxiliary.remote.http.client.RemoteHttpClientListener;
import org.apache.commons.jcs3.auxiliary.remote.http.client.behavior.IRemoteHttpCacheClient;
import org.apache.commons.jcs3.auxiliary.remote.server.behavior.RemoteType;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheManager;
import org.apache.commons.jcs3.engine.behavior.IElementSerializer;
import org.apache.commons.jcs3.engine.logging.behavior.ICacheEventLogger;
import org.apache.commons.jcs3.log.Log;
import org.apache.commons.jcs3.log.LogManager;
import org.apache.commons.jcs3.utils.config.OptionConverter;

public class RemoteHttpCacheFactory
extends AbstractAuxiliaryCacheFactory {
    private static final Log log = LogManager.getLog(RemoteHttpCacheFactory.class);
    private RemoteHttpCacheMonitor monitor;

    @Override
    public <K, V> AuxiliaryCache<K, V> createCache(AuxiliaryCacheAttributes iaca, ICompositeCacheManager cacheMgr, ICacheEventLogger cacheEventLogger, IElementSerializer elementSerializer) {
        RemoteHttpCacheAttributes rca = (RemoteHttpCacheAttributes)iaca;
        rca.setRemoteType(RemoteType.LOCAL);
        RemoteHttpClientListener listener = new RemoteHttpClientListener(rca, cacheMgr, elementSerializer);
        IRemoteHttpCacheClient<K, V> remoteService = this.createRemoteHttpCacheClientForAttributes(rca);
        RemoteHttpCache<K, V> remoteCacheClient = new RemoteHttpCache<K, V>(rca, remoteService, listener, this.monitor);
        remoteCacheClient.setCacheEventLogger(cacheEventLogger);
        remoteCacheClient.setElementSerializer(elementSerializer);
        RemoteCacheNoWait<K, V> remoteCacheNoWait = new RemoteCacheNoWait<K, V>(remoteCacheClient);
        remoteCacheNoWait.setCacheEventLogger(cacheEventLogger);
        remoteCacheNoWait.setElementSerializer(elementSerializer);
        return remoteCacheNoWait;
    }

    protected <V, K> IRemoteHttpCacheClient<K, V> createRemoteHttpCacheClientForAttributes(RemoteHttpCacheAttributes cattr) {
        RemoteHttpCacheClient remoteService = OptionConverter.instantiateByClassName(cattr.getRemoteHttpClientClassName(), null);
        if (remoteService == null) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = cattr::getCacheName;
            log.info("Creating the default client for {0}", supplierArray);
            remoteService = new RemoteHttpCacheClient();
        }
        remoteService.initialize(cattr);
        return remoteService;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.monitor = new RemoteHttpCacheMonitor(this);
        this.monitor.setDaemon(true);
        this.monitor.start();
    }

    @Override
    public void dispose() {
        if (this.monitor != null) {
            this.monitor.notifyShutdown();
            try {
                this.monitor.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.monitor = null;
        }
        super.dispose();
    }
}

