/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.access;

import java.util.HashSet;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.access.exception.CacheException;
import org.apache.commons.jcs3.access.exception.ObjectExistsException;
import org.apache.commons.jcs3.engine.CompositeCacheAttributes;
import org.apache.commons.jcs3.engine.ElementAttributes;
import org.apache.commons.jcs3.engine.behavior.ICacheElement;
import org.apache.commons.jcs3.engine.behavior.ICompositeCacheAttributes;
import org.apache.commons.jcs3.engine.behavior.IElementAttributes;

public class CacheAccessUnitTest
extends TestCase {
    public void testPutSafe() throws Exception {
        CacheAccess access = JCS.getInstance((String)"test");
        CacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
        String key = "mykey";
        String value = "myvalue";
        access.put((Object)"mykey", (Object)"myvalue");
        String returnedValue1 = (String)access.get((Object)"mykey");
        CacheAccessUnitTest.assertEquals((String)"Wrong value returned.", (String)"myvalue", (String)returnedValue1);
        try {
            access.putSafe((Object)"mykey", (Object)"someothervalue");
            CacheAccessUnitTest.fail((String)"We should have received an exception since this key is already in the cache.");
        }
        catch (CacheException e) {
            CacheAccessUnitTest.assertTrue((String)"Wrong type of exception.", (boolean)(e instanceof ObjectExistsException));
            CacheAccessUnitTest.assertTrue((String)"Should have the key in the error message.", (e.getMessage().indexOf("[mykey]") != -1 ? 1 : 0) != 0);
        }
        String returnedValue2 = (String)access.get((Object)"mykey");
        CacheAccessUnitTest.assertEquals((String)"Wrong value returned.  Should still be the original.", (String)"myvalue", (String)returnedValue2);
    }

    public void testPutNullKey() throws Exception {
        CacheAccess access = JCS.getInstance((String)"test");
        CacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
        Object key = null;
        String value = "myvalue";
        try {
            access.put(key, (Object)"myvalue");
            CacheAccessUnitTest.fail((String)"Should not have been able to put a null key.");
        }
        catch (CacheException e) {
            CacheAccessUnitTest.assertTrue((String)"Should have the word null in the error message.", (e.getMessage().indexOf("null") != -1 ? 1 : 0) != 0);
        }
    }

    public void testPutNullValue() throws Exception {
        CacheAccess access = JCS.getInstance((String)"test");
        CacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
        String key = "myKey";
        Object value = null;
        try {
            access.put((Object)"myKey", value);
            CacheAccessUnitTest.fail((String)"Should not have been able to put a null object.");
        }
        catch (CacheException e) {
            CacheAccessUnitTest.assertTrue((String)"Should have the word null in the error message.", (e.getMessage().indexOf("null") != -1 ? 1 : 0) != 0);
        }
    }

    public void testSetDefaultElementAttributes() throws Exception {
        CacheAccess access = JCS.getInstance((String)"test");
        CacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
        long maxLife = 9876L;
        ElementAttributes attr = new ElementAttributes();
        attr.setMaxLife(9876L);
        access.setDefaultElementAttributes((IElementAttributes)attr);
        CacheAccessUnitTest.assertEquals((String)"Wrong element attributes.", (long)attr.getMaxLife(), (long)access.getDefaultElementAttributes().getMaxLife());
        String key = "mykey";
        String value = "myvalue";
        access.put((Object)"mykey", (Object)"myvalue");
        ICacheElement element = access.getCacheElement((Object)"mykey");
        CacheAccessUnitTest.assertEquals((String)"Wrong max life.  Should have the new value.", (long)9876L, (long)element.getElementAttributes().getMaxLife());
    }

    public void testGetCacheElements() throws Exception {
        CacheAccess access = JCS.getInstance((String)"test");
        CacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
        String keyOne = "mykeyone";
        String keyTwo = "mykeytwo";
        String keyThree = "mykeythree";
        String keyFour = "mykeyfour";
        String valueOne = "myvalueone";
        String valueTwo = "myvaluetwo";
        String valueThree = "myvaluethree";
        String valueFour = "myvaluefour";
        access.put((Object)"mykeyone", (Object)"myvalueone");
        access.put((Object)"mykeytwo", (Object)"myvaluetwo");
        access.put((Object)"mykeythree", (Object)"myvaluethree");
        HashSet<String> input = new HashSet<String>();
        input.add("mykeyone");
        input.add("mykeytwo");
        Map result = access.getCacheElements(input);
        CacheAccessUnitTest.assertEquals((String)"map size", (int)2, (int)result.size());
        ICacheElement elementOne = (ICacheElement)result.get("mykeyone");
        CacheAccessUnitTest.assertEquals((String)"value one", (String)"mykeyone", (String)((String)elementOne.getKey()));
        CacheAccessUnitTest.assertEquals((String)"value one", (String)"myvalueone", (String)((String)elementOne.getVal()));
        ICacheElement elementTwo = (ICacheElement)result.get("mykeytwo");
        CacheAccessUnitTest.assertEquals((String)"value two", (String)"mykeytwo", (String)((String)elementTwo.getKey()));
        CacheAccessUnitTest.assertEquals((String)"value two", (String)"myvaluetwo", (String)((String)elementTwo.getVal()));
        CacheAccessUnitTest.assertNull((Object)access.get((Object)"mykeyfour"));
        String suppliedValue1 = (String)access.get((Object)"mykeyfour", () -> "myvaluefour");
        CacheAccessUnitTest.assertNotNull((String)"value four", (Object)suppliedValue1);
        CacheAccessUnitTest.assertEquals((String)"value four", (String)"myvaluefour", (String)suppliedValue1);
        String suppliedValue2 = (String)access.get((Object)"mykeyfour");
        CacheAccessUnitTest.assertNotNull((String)"value four", (Object)suppliedValue2);
        CacheAccessUnitTest.assertEquals((String)"value four", (String)suppliedValue1, (String)suppliedValue2);
    }

    public void testRegionDefiniton() throws Exception {
        CacheAccess access = JCS.getInstance((String)"test");
        CacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
    }

    public void testRegionDefinitonWithAttributes() throws Exception {
        CompositeCacheAttributes ca = new CompositeCacheAttributes();
        long maxIdleTime = 8765L;
        ca.setMaxMemoryIdleTimeSeconds(8765L);
        CacheAccess access = JCS.getInstance((String)"testRegionDefinitonWithAttributes", (ICompositeCacheAttributes)ca);
        CacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
        ICompositeCacheAttributes ca2 = access.getCacheAttributes();
        CacheAccessUnitTest.assertEquals((String)"Wrong idle time setting.", (long)ca.getMaxMemoryIdleTimeSeconds(), (long)ca2.getMaxMemoryIdleTimeSeconds());
    }

    public void testRegionDefinitonWithBothAttributes() throws Exception {
        CompositeCacheAttributes ca = new CompositeCacheAttributes();
        long maxIdleTime = 8765L;
        ca.setMaxMemoryIdleTimeSeconds(8765L);
        long maxLife = 9876L;
        ElementAttributes attr = new ElementAttributes();
        attr.setMaxLife(9876L);
        CacheAccess access = JCS.getInstance((String)"testRegionDefinitonWithAttributes", (ICompositeCacheAttributes)ca, (IElementAttributes)attr);
        CacheAccessUnitTest.assertNotNull((String)"We should have an access class", (Object)access);
        ICompositeCacheAttributes ca2 = access.getCacheAttributes();
        CacheAccessUnitTest.assertEquals((String)"Wrong idle time setting.", (long)ca.getMaxMemoryIdleTimeSeconds(), (long)ca2.getMaxMemoryIdleTimeSeconds());
    }

    public void testGetMatching_Normal() throws Exception {
        int maxMemorySize = 1000;
        String keyprefix1 = "MyPrefix1";
        String keyprefix2 = "MyPrefix2";
        String memoryCacheClassName = "org.apache.commons.jcs3.engine.memory.lru.LRUMemoryCache";
        CompositeCacheAttributes cattr = new CompositeCacheAttributes();
        cattr.setMemoryCacheName("org.apache.commons.jcs3.engine.memory.lru.LRUMemoryCache");
        cattr.setMaxObjects(1000);
        long maxLife = 9876L;
        ElementAttributes attr = new ElementAttributes();
        attr.setMaxLife(9876L);
        CacheAccess access = JCS.getInstance((String)"testGetMatching_Normal", (ICompositeCacheAttributes)cattr, (IElementAttributes)attr);
        int numToInsertPrefix1 = 10;
        for (int i = 0; i < 10; ++i) {
            access.put((Object)("MyPrefix1" + String.valueOf(i)), (Object)i);
        }
        int numToInsertPrefix2 = 50;
        for (int i = 0; i < 50; ++i) {
            access.put((Object)("MyPrefix2" + String.valueOf(i)), (Object)i);
        }
        Map result1 = access.getMatching("MyPrefix1.+");
        Map result2 = access.getMatching("MyPrefix2\\S+");
        CacheAccessUnitTest.assertEquals((String)"Wrong number returned 1:", (int)10, (int)result1.size());
        CacheAccessUnitTest.assertEquals((String)"Wrong number returned 2:", (int)50, (int)result2.size());
        for (Map.Entry entry : result1.entrySet()) {
            Object value = entry.getValue();
            CacheAccessUnitTest.assertFalse((String)"Should not be a cache element.", (boolean)(value instanceof ICacheElement));
        }
    }

    public void testGetMatchingElements_Normal() throws Exception {
        int maxMemorySize = 1000;
        String keyprefix1 = "MyPrefix1";
        String keyprefix2 = "MyPrefix2";
        String memoryCacheClassName = "org.apache.commons.jcs3.engine.memory.lru.LRUMemoryCache";
        CompositeCacheAttributes cattr = new CompositeCacheAttributes();
        cattr.setMemoryCacheName("org.apache.commons.jcs3.engine.memory.lru.LRUMemoryCache");
        cattr.setMaxObjects(1000);
        long maxLife = 9876L;
        ElementAttributes attr = new ElementAttributes();
        attr.setMaxLife(9876L);
        CacheAccess access = JCS.getInstance((String)"testGetMatching_Normal", (ICompositeCacheAttributes)cattr, (IElementAttributes)attr);
        int numToInsertPrefix1 = 10;
        for (int i = 0; i < 10; ++i) {
            access.put((Object)("MyPrefix1" + String.valueOf(i)), (Object)i);
        }
        int numToInsertPrefix2 = 50;
        for (int i = 0; i < 50; ++i) {
            access.put((Object)("MyPrefix2" + String.valueOf(i)), (Object)i);
        }
        Map result1 = access.getMatchingCacheElements("MyPrefix1\\S+");
        Map result2 = access.getMatchingCacheElements("MyPrefix2.+");
        CacheAccessUnitTest.assertEquals((String)"Wrong number returned 1:", (int)10, (int)result1.size());
        CacheAccessUnitTest.assertEquals((String)"Wrong number returned 2:", (int)50, (int)result2.size());
        for (Map.Entry entry : result1.entrySet()) {
            Object value = entry.getValue();
            CacheAccessUnitTest.assertTrue((String)"Should be a cache element.", (boolean)(value instanceof ICacheElement));
        }
    }
}

