/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.tiff.photometricinterpreters;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.imaging.ImagingException;
import org.apache.commons.imaging.ImagingFormatException;
import org.apache.commons.imaging.common.Allocator;
import org.apache.commons.imaging.common.ImageBuilder;
import org.apache.commons.imaging.formats.tiff.photometricinterpreters.AbstractPhotometricInterpreter;

public final class PhotometricInterpreterPalette
extends AbstractPhotometricInterpreter {
    private final int[] indexColorMap;
    private final int bitsPerPixelMask;

    public PhotometricInterpreterPalette(int samplesPerPixel, int[] bitsPerSample, int predictor, int width, int height, int[] colorMap) {
        super(samplesPerPixel, bitsPerSample, predictor, width, height);
        int maxI;
        int colorMapScaleX2;
        int bitsPerPixel = this.getBitsPerSample(0);
        int colorMapScale = 1 << bitsPerPixel;
        try {
            colorMapScaleX2 = Math.multiplyExact(2, colorMapScale);
        }
        catch (ArithmeticException e) {
            throw new ImagingFormatException("bitsPerPixel is too large or colorMap is too small", e);
        }
        try {
            maxI = Math.addExact(colorMapScaleX2, colorMapScale - 1);
        }
        catch (ArithmeticException e) {
            throw new ImagingFormatException("bitsPerPixel is too large or colorMap is too small", e);
        }
        if (maxI >= colorMap.length) {
            throw new ImagingFormatException("bitsPerPixel %,d (maxI = %,d) is too large or colorMap is too small %,d", bitsPerPixel, maxI, colorMap.length);
        }
        this.indexColorMap = Allocator.intArray(colorMapScale);
        Arrays.setAll(this.indexColorMap, i -> {
            int red = colorMap[i] >> 8 & 0xFF;
            int green = colorMap[i + colorMapScale] >> 8 & 0xFF;
            int blue = colorMap[i + colorMapScaleX2] >> 8 & 0xFF;
            return 0xFF000000 | red << 16 | green << 8 | blue;
        });
        int temp = 0;
        for (int i2 = 0; i2 < bitsPerPixel; ++i2) {
            temp = temp << 1 | 1;
        }
        this.bitsPerPixelMask = temp;
    }

    @Override
    public void interpretPixel(ImageBuilder imageBuilder, int[] samples, int x, int y) throws ImagingException, IOException {
        imageBuilder.setRgb(x, y, this.indexColorMap[samples[0] & this.bitsPerPixelMask]);
    }
}

