/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.png;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.imaging.ImagingParameters;
import org.apache.commons.imaging.formats.png.AbstractPngTest;
import org.apache.commons.imaging.formats.png.PngImageParser;
import org.apache.commons.imaging.formats.png.PngImagingParameters;
import org.apache.commons.imaging.internal.Debug;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PngWriteForceTrueColorText
extends AbstractPngTest {
    @Test
    public void test() throws Exception {
        PngImageParser pngImageParser = new PngImageParser();
        List<File> images = this.getPngImages();
        for (File imageFile : images) {
            try {
                byte[] outFile;
                if (this.isInvalidPngTestFile(imageFile)) continue;
                Debug.debug((String)"imageFile", (Object)imageFile);
                BufferedImage image = pngImageParser.getBufferedImage(imageFile, (ImagingParameters)new PngImagingParameters());
                Assertions.assertNotNull((Object)image);
                PngImagingParameters params = new PngImagingParameters();
                try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                    params.setForceTrueColor(Boolean.TRUE.booleanValue());
                    pngImageParser.writeImage(image, (OutputStream)os, params);
                    outFile = os.toByteArray();
                }
                BufferedImage image2 = pngImageParser.getBufferedImage(outFile, (ImagingParameters)new PngImagingParameters());
                Assertions.assertNotNull((Object)image2);
            }
            catch (Exception e) {
                Debug.debug((String)"imageFile", (Object)imageFile);
                throw e;
            }
        }
        Debug.debug((String)"complete.");
    }
}

