/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.fileupload;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class MockHttpServletRequest
implements HttpServletRequest {
    private final InputStream requestData;
    private long length;
    private final String strContentType;
    private int readLimit = -1;
    private final Map<String, String> headers = new HashMap<String, String>();

    public MockHttpServletRequest(byte[] requestData, String strContentType) {
        this(new ByteArrayInputStream(requestData), requestData.length, strContentType);
    }

    public MockHttpServletRequest(InputStream requestData, long length, String strContentType) {
        this.requestData = requestData;
        this.length = length;
        this.strContentType = strContentType;
        this.headers.put("Content-type", strContentType);
    }

    public Object getAttribute(String arg0) {
        return null;
    }

    public Enumeration<String> getAttributeNames() {
        return null;
    }

    public String getAuthType() {
        return null;
    }

    public String getCharacterEncoding() {
        return null;
    }

    public int getContentLength() {
        int iLength = 0;
        if (null == this.requestData) {
            iLength = -1;
        } else {
            if (this.length > Integer.MAX_VALUE) {
                throw new RuntimeException("Value '" + this.length + "' is too large to be converted to int");
            }
            iLength = (int)this.length;
        }
        return iLength;
    }

    public String getContentType() {
        return this.strContentType;
    }

    public String getContextPath() {
        return null;
    }

    public Cookie[] getCookies() {
        return null;
    }

    public long getDateHeader(String arg0) {
        return 0L;
    }

    public String getHeader(String headerName) {
        return this.headers.get(headerName);
    }

    public Enumeration<String> getHeaderNames() {
        return null;
    }

    public Enumeration<String> getHeaders(String arg0) {
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        return new MyServletInputStream(this.requestData, this.readLimit);
    }

    public int getIntHeader(String arg0) {
        return 0;
    }

    public String getLocalAddr() {
        return null;
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration<Locale> getLocales() {
        return null;
    }

    public String getLocalName() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public String getMethod() {
        return null;
    }

    public String getParameter(String arg0) {
        return null;
    }

    public Map<String, String[]> getParameterMap() {
        return null;
    }

    public Enumeration<String> getParameterNames() {
        return null;
    }

    public String[] getParameterValues(String arg0) {
        return null;
    }

    public String getPathInfo() {
        return null;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getProtocol() {
        return null;
    }

    public String getQueryString() {
        return null;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    @Deprecated
    public String getRealPath(String arg0) {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public String getRemoteUser() {
        return null;
    }

    public RequestDispatcher getRequestDispatcher(String arg0) {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getRequestURI() {
        return null;
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    public String getScheme() {
        return null;
    }

    public String getServerName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }

    public String getServletPath() {
        return null;
    }

    public HttpSession getSession() {
        return null;
    }

    public HttpSession getSession(boolean arg0) {
        return null;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isSecure() {
        return false;
    }

    public boolean isUserInRole(String arg0) {
        return false;
    }

    public void removeAttribute(String arg0) {
    }

    public void setAttribute(String arg0, Object arg1) {
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
    }

    public void setContentLength(long length) {
        this.length = length;
    }

    public void setReadLimit(int readLimit) {
        this.readLimit = readLimit;
    }

    private static class MyServletInputStream
    extends ServletInputStream {
        private final InputStream in;
        private final int readLimit;

        MyServletInputStream(InputStream in, int readLimit) {
            this.in = in;
            this.readLimit = readLimit;
        }

        public int read() throws IOException {
            return this.in.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            if (this.readLimit > 0) {
                return this.in.read(b, off, Math.min(this.readLimit, len));
            }
            return this.in.read(b, off, len);
        }
    }
}

