/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.ar;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import org.apache.commons.compress.AbstractTest;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class ArArchiveOutputStreamTest
extends AbstractTest {
    ArArchiveOutputStreamTest() {
    }

    @Test
    void testLongFileNamesCauseExceptionByDefault() throws IOException {
        ArArchiveOutputStream ref;
        try (ArArchiveOutputStream outputStream = new ArArchiveOutputStream((OutputStream)new ByteArrayOutputStream());){
            ref = outputStream;
            ArArchiveEntry ae = new ArArchiveEntry("this_is_a_long_name.txt", 0L);
            IOException ex = (IOException)Assertions.assertThrows(IOException.class, () -> outputStream.putArchiveEntry(ae));
            Assertions.assertTrue((boolean)ex.getMessage().startsWith("File name too long"));
        }
        Assertions.assertTrue((boolean)ref.isClosed());
    }

    @Test
    void testLongFileNamesWorkUsingBSDDialect() throws Exception {
        File file = this.createTempFile();
        try (ArArchiveOutputStream outputStream = new ArArchiveOutputStream(Files.newOutputStream(file.toPath(), new OpenOption[0]));){
            outputStream.setLongFileMode(1);
            ArArchiveEntry ae = new ArArchiveEntry("this_is_a_long_name.txt", 14L);
            outputStream.putArchiveEntry(ae);
            outputStream.write(new byte[]{72, 101, 108, 108, 111, 44, 32, 119, 111, 114, 108, 100, 33, 10});
            outputStream.closeArchiveEntry();
            ArrayList<String> expected = new ArrayList<String>();
            expected.add("this_is_a_long_name.txt");
            this.checkArchiveContent(file, expected);
        }
    }
}

