/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.dba;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.DataRow;
import org.apache.cayenne.ObjectId;
import org.apache.cayenne.ResultIterator;
import org.apache.cayenne.access.DataNode;
import org.apache.cayenne.access.OperationObserver;
import org.apache.cayenne.dba.DbAdapter;
import org.apache.cayenne.dba.JdbcAdapter;
import org.apache.cayenne.dba.PkGenerator;
import org.apache.cayenne.map.DbAttribute;
import org.apache.cayenne.map.DbEntity;
import org.apache.cayenne.map.DbKeyGenerator;
import org.apache.cayenne.query.Query;
import org.apache.cayenne.query.SQLTemplate;
import org.apache.cayenne.util.IDUtil;

public class JdbcPkGenerator
implements PkGenerator {
    public static final int DEFAULT_PK_CACHE_SIZE = 20;
    static final long DEFAULT_PK_START_VALUE = 200L;
    protected JdbcAdapter adapter;
    protected ConcurrentMap<String, Queue<Long>> pkCache = new ConcurrentHashMap<String, Queue<Long>>();
    protected int pkCacheSize = 20;
    protected long pkStartValue = 200L;

    public JdbcPkGenerator() {
    }

    public JdbcPkGenerator(JdbcAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public JdbcAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public void createAutoPk(DataNode node, List<DbEntity> dbEntities) throws Exception {
        if (!this.autoPkTableExists(node)) {
            this.runUpdate(node, this.pkTableCreateString());
        }
        if (!dbEntities.isEmpty()) {
            this.runUpdate(node, this.pkDeleteString(dbEntities));
        }
        for (DbEntity ent : dbEntities) {
            this.runUpdate(node, this.pkCreateString(ent.getName()));
        }
    }

    @Override
    public List<String> createAutoPkStatements(List<DbEntity> dbEntities) {
        ArrayList<String> list = new ArrayList<String>(dbEntities.size() + 2);
        list.add(this.pkTableCreateString());
        list.add(this.pkDeleteString(dbEntities));
        for (DbEntity ent : dbEntities) {
            list.add(this.pkCreateString(ent.getName()));
        }
        return list;
    }

    @Override
    public void dropAutoPk(DataNode node, List<DbEntity> dbEntities) throws Exception {
        if (this.autoPkTableExists(node)) {
            this.runUpdate(node, this.dropAutoPkString());
        }
    }

    @Override
    public List<String> dropAutoPkStatements(List<DbEntity> dbEntities) {
        ArrayList<String> list = new ArrayList<String>(1);
        list.add(this.dropAutoPkString());
        return list;
    }

    protected String pkTableCreateString() {
        return "CREATE TABLE AUTO_PK_SUPPORT (TABLE_NAME CHAR(100) NOT NULL, NEXT_ID BIGINT NOT NULL, PRIMARY KEY(TABLE_NAME))";
    }

    protected String pkDeleteString(List<DbEntity> dbEntities) {
        StringBuilder buf = new StringBuilder();
        buf.append("DELETE FROM AUTO_PK_SUPPORT WHERE TABLE_NAME IN (");
        int len = dbEntities.size();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            DbEntity ent = dbEntities.get(i);
            buf.append('\'').append(ent.getName()).append('\'');
        }
        buf.append(')');
        return buf.toString();
    }

    protected String pkCreateString(String entName) {
        return "INSERT INTO AUTO_PK_SUPPORT (TABLE_NAME, NEXT_ID) VALUES ('" + entName + "', " + this.pkStartValue + ")";
    }

    protected String pkSelectString(String entName) {
        return "SELECT NEXT_ID FROM AUTO_PK_SUPPORT WHERE TABLE_NAME = '" + entName + "'";
    }

    protected String pkUpdateString(String entName) {
        return "UPDATE AUTO_PK_SUPPORT SET NEXT_ID = NEXT_ID + " + this.pkCacheSize + " WHERE TABLE_NAME = '" + entName + "'";
    }

    protected String dropAutoPkString() {
        return "DROP TABLE AUTO_PK_SUPPORT";
    }

    protected boolean autoPkTableExists(DataNode node) throws SQLException {
        try (Connection con = node.getDataSource().getConnection();){
            boolean bl;
            block12: {
                DatabaseMetaData md = con.getMetaData();
                ResultSet tables = md.getTables(null, null, "AUTO_PK_SUPPORT", null);
                try {
                    bl = tables.next();
                    if (tables == null) break block12;
                }
                catch (Throwable throwable) {
                    if (tables != null) {
                        try {
                            tables.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                tables.close();
            }
            return bl;
        }
    }

    public int runUpdate(DataNode node, String sql) throws SQLException {
        this.adapter.getJdbcEventLogger().log(sql);
        try (Connection con = node.getDataSource().getConnection();){
            int n;
            block12: {
                Statement upd = con.createStatement();
                try {
                    n = upd.executeUpdate(sql);
                    if (upd == null) break block12;
                }
                catch (Throwable throwable) {
                    if (upd != null) {
                        try {
                            upd.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                upd.close();
            }
            return n;
        }
    }

    @Override
    public Object generatePk(DataNode node, DbAttribute pk) throws Exception {
        Long value;
        DbEntity entity = pk.getEntity();
        switch (pk.getType()) {
            case -3: 
            case -2: {
                return IDUtil.pseudoUniqueSecureByteSequence(pk.getMaxLength());
            }
        }
        DbKeyGenerator pkGenerator = entity.getPrimaryKeyGenerator();
        long cacheSize = pkGenerator != null && pkGenerator.getKeyCacheSize() != null ? (long)pkGenerator.getKeyCacheSize().intValue() : (long)this.getPkCacheSize();
        if (cacheSize <= 1L) {
            value = this.longPkFromDatabase(node, entity);
        } else {
            Queue<Long> pks = (ConcurrentLinkedQueue)this.pkCache.get(entity.getName());
            if (pks == null) {
                pks = new ConcurrentLinkedQueue();
                Queue previousPks = this.pkCache.putIfAbsent(entity.getName(), pks);
                if (previousPks != null) {
                    pks = previousPks;
                }
            }
            if ((value = (Long)pks.poll()) == null) {
                value = this.longPkFromDatabase(node, entity);
                for (long i = value + 1L; i < value + cacheSize; ++i) {
                    pks.add(i);
                }
            }
        }
        if (pk.getType() == -5) {
            return value;
        }
        return value.intValue();
    }

    @Override
    public void setAdapter(DbAdapter adapter) {
        this.adapter = (JdbcAdapter)adapter;
    }

    protected long longPkFromDatabase(DataNode node, DbEntity entity) throws Exception {
        String select = "SELECT #result('NEXT_ID' 'long' 'NEXT_ID') FROM AUTO_PK_SUPPORT WHERE TABLE_NAME = '" + entity.getName() + "'";
        ArrayList<SQLTemplate> queries = new ArrayList<SQLTemplate>(2);
        queries.add(new SQLTemplate(entity, select));
        queries.add(new SQLTemplate(entity, this.pkUpdateString(entity.getName())));
        PkRetrieveProcessor observer = new PkRetrieveProcessor(entity.getName());
        node.performQueries(queries, observer);
        return observer.getId();
    }

    public int getPkCacheSize() {
        return this.pkCacheSize;
    }

    public void setPkCacheSize(int pkCacheSize) {
        this.pkCacheSize = pkCacheSize < 1 ? 1 : pkCacheSize;
    }

    long getPkStartValue() {
        return this.pkStartValue;
    }

    void setPkStartValue(long startValue) {
        this.pkStartValue = startValue;
    }

    @Override
    public void reset() {
        this.pkCache.clear();
    }

    final class PkRetrieveProcessor
    implements OperationObserver {
        Number id;
        final String entityName;

        PkRetrieveProcessor(String entityName) {
            this.entityName = entityName;
        }

        @Override
        public boolean isIteratedResult() {
            return false;
        }

        public long getId() {
            if (this.id == null) {
                throw new CayenneRuntimeException("No key was retrieved for entity %s", this.entityName);
            }
            return this.id.longValue();
        }

        @Override
        public void nextRows(Query query, List<?> dataRows) {
            if (dataRows == null || dataRows.size() == 0) {
                throw new CayenneRuntimeException("Error generating PK : entity not supported: %s", this.entityName);
            }
            if (dataRows.size() > 1) {
                throw new CayenneRuntimeException("Error generating PK : too many rows for entity: %s", this.entityName);
            }
            DataRow lastPk = (DataRow)dataRows.get(0);
            this.id = (Number)lastPk.get("NEXT_ID");
        }

        @Override
        public void nextCount(Query query, int resultCount) {
            if (resultCount != 1) {
                throw new CayenneRuntimeException("Error generating PK for entity '%s': update count is wrong - %d", this.entityName, resultCount);
            }
        }

        @Override
        public void nextBatchCount(Query query, int[] resultCount) {
        }

        @Override
        public void nextGeneratedRows(Query query, ResultIterator<?> keys, List<ObjectId> idsToUpdate) {
        }

        public void nextRows(Query q, ResultIterator it) {
        }

        @Override
        public void nextQueryException(Query query, Exception ex) {
            throw new CayenneRuntimeException("Error generating PK for entity '" + this.entityName + "'.", (Throwable)ex, new Object[0]);
        }

        @Override
        public void nextGlobalException(Exception ex) {
            throw new CayenneRuntimeException("Error generating PK for entity: " + this.entityName, (Throwable)ex, new Object[0]);
        }
    }
}

