/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.clustering.tribes;

import java.io.Serializable;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.management.DefaultNodeManager;
import org.apache.axis2.clustering.management.GroupManagementCommand;
import org.apache.axis2.clustering.management.NodeManagementCommand;
import org.apache.axis2.clustering.state.DefaultStateManager;
import org.apache.axis2.clustering.state.StateClusteringCommand;
import org.apache.axis2.clustering.tribes.ClassLoaderUtil;
import org.apache.axis2.clustering.tribes.TribesUtil;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.catalina.tribes.ByteMessage;
import org.apache.catalina.tribes.ChannelListener;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.group.RpcMessage;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Axis2ChannelListener
implements ChannelListener {
    private static final Log log = LogFactory.getLog(Axis2ChannelListener.class);
    private DefaultStateManager stateManager;
    private DefaultNodeManager nodeManager;
    private ConfigurationContext configurationContext;

    public Axis2ChannelListener(ConfigurationContext configurationContext, DefaultNodeManager nodeManager, DefaultStateManager stateManager) {
        this.nodeManager = nodeManager;
        this.stateManager = stateManager;
        this.configurationContext = configurationContext;
    }

    public void setStateManager(DefaultStateManager stateManager) {
        this.stateManager = stateManager;
    }

    public void setNodeManager(DefaultNodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    public void setConfigurationContext(ConfigurationContext configurationContext) {
        this.configurationContext = configurationContext;
    }

    public boolean accept(Serializable msg, Member sender) {
        return !(msg instanceof RpcMessage);
    }

    public void messageReceived(Serializable msg, Member sender) {
        try {
            byte[] message = ((ByteMessage)msg).getMessage();
            msg = XByteBuffer.deserialize((byte[])message, (int)0, (int)message.length, (ClassLoader[])ClassLoaderUtil.getClassLoaders());
        }
        catch (Exception e) {
            String errMsg = "Cannot deserialize received message";
            log.error((Object)errMsg, (Throwable)e);
            throw new RemoteProcessException(errMsg, (Throwable)e);
        }
        if (this.configurationContext.getPropertyNonReplicable("local_cluster.initialized") == null) {
            log.warn((Object)("Received message " + String.valueOf(msg) + " before cluster initialization has been completed from " + TribesUtil.getName(sender)));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received message " + String.valueOf(msg) + " from " + TribesUtil.getName(sender)));
        }
        try {
            this.processMessage(msg);
        }
        catch (Exception e) {
            String errMsg = "Cannot process received message";
            log.error((Object)errMsg, (Throwable)e);
            throw new RemoteProcessException(errMsg, (Throwable)e);
        }
    }

    private void processMessage(Serializable msg) throws ClusteringFault {
        if (msg instanceof StateClusteringCommand && this.stateManager != null) {
            StateClusteringCommand ctxCmd = (StateClusteringCommand)msg;
            ctxCmd.execute(this.configurationContext);
        } else if (msg instanceof NodeManagementCommand && this.nodeManager != null) {
            ((NodeManagementCommand)msg).execute(this.configurationContext);
        } else if (msg instanceof GroupManagementCommand) {
            ((GroupManagementCommand)msg).execute(this.configurationContext);
        }
    }
}

