/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.server.endpoint.injection.impl;

import jakarta.xml.ws.WebServiceContext;
import jakarta.xml.ws.handler.MessageContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.axis2.java.security.AccessController;
import org.apache.axis2.jaxws.context.WebServiceContextImpl;
import org.apache.axis2.jaxws.i18n.Messages;
import org.apache.axis2.jaxws.injection.ResourceInjectionException;
import org.apache.axis2.jaxws.server.endpoint.injection.WebServiceContextInjector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebServiceContextInjectorImpl
implements WebServiceContextInjector {
    private static final Log log = LogFactory.getLog(WebServiceContextInjectorImpl.class);
    private static String METHOD_NAME = "set";
    private static int NUMBER_OF_PARAMETERS = 1;
    private static String RETURN_TYPE = "void";

    @Override
    public void addMessageContext(WebServiceContext wc, MessageContext mc) {
        WebServiceContextImpl wsContext = (WebServiceContextImpl)wc;
        wsContext.setSoapMessageContext(mc);
    }

    @Override
    public void inject(Object resource, Object instance) throws ResourceInjectionException {
        if (instance == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot inject Resource on a null Service Instance.");
            }
            throw new ResourceInjectionException(Messages.getMessage((String)"WebServiceContextInjectionImplErr1"));
        }
        Class<?> serviceClazz = instance.getClass();
        Field resourceField = this.searchFieldsForResourceAnnotation(serviceClazz);
        if (resourceField != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Attempting to inject Resource on Field");
            }
            this.injectOnField(resource, instance, resourceField);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Resource Injected on Field");
            }
            return;
        }
        Method method = this.searchMethodsResourceAnnotation(serviceClazz);
        if (method != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Attempting to inject resource on Method");
            }
            if (!this.isValidMethod(method)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"injection can happen using method if method name starts with \"set\" returns a void and only has one parameter and the type of this parameter must be compatible with resource.");
                }
                throw new ResourceInjectionException(Messages.getMessage((String)"WebServiceContextInjectionImplErr6"));
            }
            this.injectOnMethod(resource, instance, method);
            if (log.isDebugEnabled()) {
                log.debug((Object)"Resource Injected");
            }
            return;
        }
    }

    @Override
    public void injectOnClass(Object resource, Object instance, Class clazz) throws ResourceInjectionException {
        throw new UnsupportedOperationException(Messages.getMessage((String)"injectOnClsErr"));
    }

    @Override
    public void injectOnField(Object resource, Object instance, Field field) throws ResourceInjectionException {
        if (instance == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot inject Resource on a null Service Instance.");
            }
            throw new ResourceInjectionException(Messages.getMessage((String)"WebServiceContextInjectionImplErr1"));
        }
        if (field == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot inject WebServiceContext on ServiceInstance Field, field cannot be NULL");
            }
            throw new ResourceInjectionException(Messages.getMessage((String)"WebServiceContextInjectionImplErr3"));
        }
        try {
            if (!Modifier.isPublic(field.getModifiers())) {
                WebServiceContextInjectorImpl.setAccessible(field, true);
            }
            field.set(instance, resource);
        }
        catch (IllegalAccessException e) {
            throw new ResourceInjectionException(e);
        }
    }

    @Override
    public void injectOnMethod(Object resource, Object instance, Method method) throws ResourceInjectionException {
        if (instance == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot inject Resource on a null Service Instance.");
            }
            throw new ResourceInjectionException(Messages.getMessage((String)"WebServiceContextInjectionImplErr1"));
        }
        if (method == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Cannot inject WebServiceContext on ServiceInstance Method, method cannot be NULL");
            }
            throw new ResourceInjectionException(Messages.getMessage((String)"WebServiceContextInjectionImplErr3"));
        }
        try {
            if (!Modifier.isPublic(method.getModifiers())) {
                WebServiceContextInjectorImpl.setAccessible(method, true);
            }
            method.invoke(instance, resource);
            return;
        }
        catch (IllegalAccessException e) {
            throw new ResourceInjectionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ResourceInjectionException(e);
        }
    }

    private static void setAccessible(final AccessibleObject obj, final boolean value) {
        AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                obj.setAccessible(value);
                return null;
            }
        });
    }

    private Field searchFieldsForResourceAnnotation(Class bean) {
        if (bean == null) {
            return null;
        }
        List<Field> fields = WebServiceContextInjectorImpl.getFields(bean);
        for (Field field : fields) {
            Annotation[] annotations;
            for (Annotation an : annotations = field.getAnnotations()) {
                if (!Resource.class.isAssignableFrom(an.getClass())) continue;
                Resource atResource = (Resource)an;
                Class type = atResource.type();
                if (!this.isWebServiceContextResource(atResource, field)) continue;
                return field;
            }
        }
        return null;
    }

    private static List<Field> getFields(final Class beanClass) {
        List fields = (List)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                ArrayList<Field> fields = new ArrayList<Field>();
                for (Class cls = beanClass; cls != null; cls = cls.getSuperclass()) {
                    Field[] fieldArray;
                    for (Field field : fieldArray = cls.getDeclaredFields()) {
                        fields.add(field);
                    }
                }
                return fields;
            }
        });
        return fields;
    }

    private static List<Method> getMethods(final Class beanClass) {
        List methods = (List)AccessController.doPrivileged((PrivilegedAction)new PrivilegedAction(){

            public Object run() {
                ArrayList<Method> methods = new ArrayList<Method>();
                for (Class cls = beanClass; cls != null; cls = cls.getSuperclass()) {
                    Method[] methodArray;
                    for (Method method : methodArray = cls.getDeclaredMethods()) {
                        methods.add(method);
                    }
                }
                return methods;
            }
        });
        return methods;
    }

    private Method searchMethodsResourceAnnotation(Class bean) {
        if (bean == null) {
            return null;
        }
        List<Method> methods = WebServiceContextInjectorImpl.getMethods(bean);
        for (Method method : methods) {
            Annotation[] annotations;
            for (Annotation an : annotations = method.getAnnotations()) {
                Resource atResource;
                if (!Resource.class.isAssignableFrom(an.getClass()) || !this.isWebServiceContextResource(atResource = (Resource)an, method)) continue;
                return method;
            }
        }
        return null;
    }

    private boolean isWebServiceContextResource(Resource atResource, Field field) {
        Class type = atResource.type();
        if (type == Object.class ? field != null && field.getType() == WebServiceContext.class : type == WebServiceContext.class) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Invalid Field type or Resource Type found, cannot inject WebServiceContext on this field");
        }
        return false;
    }

    private boolean isWebServiceContextResource(Resource atResource, Method method) {
        Class<?>[] paramTypes;
        Class type = atResource.type();
        for (Class<WebServiceContext> clazz : paramTypes = method.getParameterTypes()) {
            if (!(type == Object.class ? clazz == WebServiceContext.class || clazz.isAssignableFrom(WebServiceContext.class) : type == WebServiceContext.class)) continue;
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Invalid Field type or Resource Type found, cannot inject WebServiceContext on this method");
        }
        return false;
    }

    private boolean isValidMethod(Method method) {
        String name = method.getName();
        Class<?> returnType = method.getReturnType();
        Class<?>[] types = method.getParameterTypes();
        int noOfDeclaredParameter = 0;
        if (types != null) {
            noOfDeclaredParameter = types.length;
        }
        if (name.startsWith(METHOD_NAME) && noOfDeclaredParameter == NUMBER_OF_PARAMETERS && returnType.getName().equals(RETURN_TYPE)) {
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Method found with @Resource annotaion and input param to set WebServiceContext Object, However method did not meet the criteria for injection as per JSR-250");
        }
        return false;
    }
}

