/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.core.impl.wireformat;

import java.util.Objects;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.core.protocol.core.impl.PacketImpl;

public class ReplicationLargeMessageEndMessage
extends PacketImpl {
    long messageId;
    long pendingRecordId;
    private boolean isDelete;

    public ReplicationLargeMessageEndMessage() {
        super((byte)100);
    }

    public ReplicationLargeMessageEndMessage(long messageId, long pendingRecordId, boolean isDelete) {
        this();
        this.messageId = messageId;
        this.pendingRecordId = -pendingRecordId;
        this.isDelete = isDelete;
    }

    public int expectedEncodeSize() {
        return 30;
    }

    public void encodeRest(ActiveMQBuffer buffer) {
        buffer.writeLong(this.messageId);
        buffer.writeLong(this.pendingRecordId);
        buffer.writeBoolean(this.isDelete);
    }

    public void decodeRest(ActiveMQBuffer buffer) {
        this.messageId = buffer.readLong();
        if (buffer.readableBytes() >= 8) {
            this.pendingRecordId = buffer.readLong();
        }
        if (buffer.readableBytes() >= 1) {
            this.isDelete = buffer.readBoolean();
        }
    }

    public long getMessageId() {
        return this.messageId;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.isDelete, this.messageId);
    }

    protected String getPacketString() {
        return super.getPacketString() + "messageId=" + this.messageId + ", isDelete=" + this.isDelete;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ReplicationLargeMessageEndMessage)) {
            return false;
        }
        ReplicationLargeMessageEndMessage other = (ReplicationLargeMessageEndMessage)((Object)obj);
        return this.messageId == other.messageId && this.isDelete == other.isDelete;
    }

    public long getPendingRecordId() {
        return this.pendingRecordId;
    }

    public boolean isDelete() {
        return this.isDelete;
    }
}

