package com.streamsicle.fluid;

import java.net.*;
import java.io.*;
import java.util.*;

/**
 * This class is used to verify that a client connection is
 * coming from an allowed host. An invalid connection
 * will be closed immediately.
 *
 * @author Lars Samuelsson
 * @author forked by John Watkinson
 */
public class ClientValidator {
    private Socket client;
    private Date timestamp;
    private InetAddress address;
    private boolean valid;
    private Vector hostsList;

    /**
     * Creates a client verificator on the specified socket.
     *
     * @param client The socket for this client connection
     * @param query  The query information from this client
     */

    public ClientValidator(String fileName) {
        hostsList = new Vector();
        parseRulesFile(fileName);
    }

    /**
     * Checks if the associated internet address is from
     * an allowed host.
     *
     * If the specified rule file could
     * not be found, the default action is to disallow
     * all connections.
     *
     * @return true if this host is allowed to connect
     */
    public boolean isValid(InetAddress address) {
	timestamp = new Date();
	return isAllowed(address);
    }
    /**
     * String containing connection time and address for
     * this host.
     *
     * @return Connection time and address
     */
    public String toString() {
	return "[" + timestamp + "]: " + address;
    }

    private void parseRulesFile(String ruleFile) {
	try {
	    BufferedReader rules = new BufferedReader(new
		InputStreamReader(new FileInputStream(ruleFile)));
	    String rule, host;
	    while((rule = rules.readLine()) != null) {
              hostsList.addElement(rule);
	    }
	}
	catch(IOException e) {
	    hostsList = null; // allow none if file is bad
	}
    }

    // checks the address against the rules
    private boolean isAllowed(InetAddress address) {
	boolean all = false;
        String rule, host;

        if (hostsList != null) {  // if the file was invalid, return false
          for (Enumeration e = hostsList.elements(); e.hasMoreElements();) {
            rule = (String)e.nextElement();
		if(rule.startsWith("+")) {
              all = true;
		    host = rule.substring(1, rule.length()).trim();
              // this is a unix-style rule
              StringTokenizer st_rule = new StringTokenizer(host,".");
              StringTokenizer st_host = new StringTokenizer(address.getHostAddress(),".");
              String ruleToken = null, hostToken = null;
              while (st_rule.hasMoreTokens()) {
                ruleToken = (String)st_rule.nextToken();
                hostToken = (String)st_host.nextToken();
                if ( (!ruleToken.equals(hostToken)) && (!ruleToken.equals("*"))) {
                  all = false;
                }
              }
              if (all == true) {
                    return true;
		}
              else if(host.toUpperCase().equals("ALL")) {
                  return true;
              }
	    }
            // at this point there's no need to check anything.  if the hostname
            // wasn't explicitly in the file, or 'ALL' wasn't in the file
            // they aren't a valid client to stream data to
          }
	} 
	return all;
    }
}




