/******************************************************************************
  (c) Copyright 2002-2006, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: SoundPlayer.java,v $
  Version:       $Name:  $ $Revision: 1.1 $
  Last Modified: $Date: 2006/02/20 16:56:50 $
 *****************************************************************************/

package org.ten60.netkernel.pingpong.transport;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.*;

import com.ten60.netkernel.urii.aspect.IAspectReadableBinaryStream;
import java.util.*;

/**
 * Basic sample player
 * @author  tab
 */
public class SoundPlayer implements LineListener
{
	
	public void playSound(IAspectReadableBinaryStream aSound, float aGain)
    {
        SourceDataLine line=null;
        AudioInputStream audioInputStream=null;
        try
        {   // get sample
            audioInputStream = AudioSystem.getAudioInputStream(aSound.getInputStream());
            AudioFormat audioFormat = audioInputStream.getFormat();
            // find and prepare line
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
            line = (SourceDataLine) AudioSystem.getLine(info);
			if (!line.isOpen())
			{	line.open(audioFormat);
				line.start();
			}
			
			FloatControl c=(FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
			
			c.setValue(aGain);
			
            //play sample
            int bytesRead = 0;
            byte[] buffer = new byte[1024];
            while (bytesRead != -1)
            {
                bytesRead = audioInputStream.read(buffer);
                if (bytesRead >= 0)
                {   line.write(buffer, 0, bytesRead);
                }
            }
            //wait
			line.addLineListener(this);
			/*
			final SourceDataLine l=line;
			Thread t=new Thread()
			{	public void run()
				{	l.drain();
					l.close();
				}
			};
			t.start();*/
        }
        catch (Exception e)
        {   // just ignore
            e.printStackTrace();
        }
        finally
        {   try
            {   if (audioInputStream!=null)
                {   audioInputStream.close();
                }
            } catch (Exception e) {}
        }
	}
	
	public void update(LineEvent event)
	{	System.out.println(event.getType().toString());
		
		if (event.getType().equals(LineEvent.Type.STOP))
		{	
			SourceDataLine line = (SourceDataLine)event.getLine();
			line.removeLineListener(this);
			line.close();

		}
	}
	
	private Map mStreamToClip = new HashMap();
	
	public void playSound2(IAspectReadableBinaryStream aSound, float aGain)
	{
		AudioInputStream ain = null;
		try
		{	Clip clip=(Clip)mStreamToClip.get(aSound);
			if (clip==null)
			{
				ain=AudioSystem.getAudioInputStream(aSound.getInputStream());
				DataLine.Info info = new DataLine.Info(Clip.class,ain.getFormat( ));
				clip = (Clip) AudioSystem.getLine(info);
				clip.open(ain);
				mStreamToClip.put(aSound,clip);
			}

			FloatControl gainControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
			if (gainControl!=null)
			{	gainControl.setValue(aGain);
			}
			clip.setFramePosition(0);
			clip.start();
		}
		catch (Exception e)
		{	e.printStackTrace();
		}
		finally
		{	try
			{	if (ain!=null) ain.close( );
			} catch (Exception e) {;}
		}
		
	}
	
	
}
