/******************************************************************************
  (c) Copyright 2002-2006, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: ControlPanel.java,v $
  Version:       $Name:  $ $Revision: 1.2 $
  Last Modified: $Date: 2006/03/02 14:20:29 $
 *****************************************************************************/
package org.ten60.netkernel.pingpong.transport;

import org.ten60.netkernel.pingpong.representation.*;
import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.representation.*;

import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xda.*;

import javax.swing.*;
import java.awt.*;
import java.util.*;
import java.awt.event.*;
import java.net.URL;
/**
 * Control Panel for application
 * @author  tab
 */
public class ControlPanel extends JPanel implements ActionListener
{
	private PingPongFrame mFrame;
	private JComboBox mNames;
	private JTextField mValue;	
	private JButton mReset;
	private JComboBox mPresets;
	private JButton mSave;
	private JButton mHelp;
	
	/** Creates a new instance of ControlPanel */
	public ControlPanel(PingPongFrame aFrame) throws NKFException, XPathLocationException
	{	mFrame=aFrame;
		setLayout(new FlowLayout(FlowLayout.LEFT));
		
		mPresets=new JComboBox();
		mPresets.setEditable(true);
		mPresets.setToolTipText("select a preset to load or enter name and click save");
		initialisePresets();
		add(mPresets);
		mPresets.setLightWeightPopupEnabled(false);
		mPresets.addActionListener(this);
		
		URL url = getClass().getClassLoader().getResource("org/ten60/netkernel/pingpong/transport/save.gif");
		try
		{	Icon c = new ImageIcon(url);
			mSave = new JButton(c);
		} catch (Exception e)
		{	mSave = new JButton("save");
		}
		mSave.setMargin(new Insets(1,1,1,1));
	
		add(mSave);
		mSave.addActionListener(this);
		mSave.setToolTipText("click to save current configuration");
		
		
		mNames = new JComboBox();
		for (Iterator i=mFrame.getConstants().getNames(); i.hasNext(); )
		{	String name=(String)i.next();
			mNames.addItem(name);
		}
		mNames.setLightWeightPopupEnabled(false);
		mNames.addActionListener(this);
		add(mNames);
		mNames.setToolTipText("select of configuration value to view/edit");

		mValue = new JTextField(8);
		add(mValue);
		mValue.addActionListener(this);
		mValue.setToolTipText("change value and press enter to set");
		
		url = getClass().getClassLoader().getResource("org/ten60/netkernel/pingpong/transport/refresh.gif");
		try
		{	Icon c = new ImageIcon(url);
			mReset = new JButton(c);
		} catch (Exception e)
		{	mReset = new JButton("reset");
		}
		mReset.setMargin(new Insets(1,1,1,1));
		add(mReset);
		mReset.addActionListener(this);
		mReset.setToolTipText("click to restart simulation");

		url = getClass().getClassLoader().getResource("org/ten60/netkernel/pingpong/transport/help.gif");
		try
		{	Icon c = new ImageIcon(url);
			mHelp = new JButton(c);
		} catch (Exception e)
		{	mHelp = new JButton("help");
		}
		mHelp.setMargin(new Insets(1,1,1,1));
		add(mHelp);
		mHelp.addActionListener(this);
		mHelp.setToolTipText("find out more...");
		
		
		ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
	}
	
	private void initialisePresets() throws NKFException, XPathLocationException
	{	mPresets.removeAllItems();
		mPresets.addItem("--select one--");
		INKFConvenienceHelper context = mFrame.getRequestContext();
		IAspectXDA presets=(IAspectXDA)context.sourceAspect("ffcpl:/pingpong/constants/presets",IAspectXDA.class);
		for (IXDAReadOnlyIterator i=presets.getXDA().readOnlyIterator("//res"); i.hasNext(); )
		{	i.next();
			mPresets.addItem(i.getText(".",true));
		}
		mPresets.setSelectedIndex(0);
	}
	
	public void actionPerformed(ActionEvent e)
	{	if (e.getSource()==mNames)
		{	setConstantInField();
		} 
		else if (e.getSource()==mValue)
		{	String name = (String)mNames.getSelectedItem();
			String valueString = mValue.getText();
			Number value;
			Class c=mFrame.getConstants().getValue(name).getClass();
			if (c==Float.class)
			{	value = new Float(valueString);
			}
			else
			{	value = new Integer(valueString);
			}
			try
			{	ConstantsAspect aspect = new ConstantsAspect(mFrame.getConstants());
				aspect.setValue(name,value);
				mFrame.getRequestContext().sinkAspect("ffcpl:/pingpong/constants/current", aspect);
			} catch (NKFException e2)
			{ e2.printStackTrace();
			}			
		}
		else if (e.getSource()==mSave)
		{	if (mPresets.getSelectedIndex()!=0)
			{	String name = (String)mPresets.getSelectedItem();
				try
				{	INKFConvenienceHelper context = mFrame.getUI().getRequestContext();
					INKFRequest req = context.createSubRequest();
					req.setURI("ffcpl:/pingpong/constants/savePreset");
					req.addArgument("name",new StringAspect(name));
					context.issueSubRequest(req);
					initialisePresets();
				} catch(Exception e2)
				{	System.out.println(e2.toString());
				}
			}
		}
		else if (e.getSource()==mPresets || e.getSource()==mReset)
		{	String name=null;
			if (mPresets.getSelectedIndex()>0)
			{	name = (String)mPresets.getSelectedItem();
			}
			if (name!=null || e.getSource()==mReset)
			{	try
				{	INKFConvenienceHelper context = mFrame.getUI().getRequestContext();
					INKFRequest req = context.createSubRequest();
					req.setURI("ffcpl:/pingpong/constants/loadPreset");
					if (name!=null)
					{	req.addArgument("name",new StringAspect(name));
					}
					context.issueSubRequest(req);
				} catch (NKFException e2)
				{ e2.printStackTrace();
				}		
			}
		}
		else if (e.getSource()==mHelp)
		{	new AboutWindow().setVisible(true);	
		}
	}
	
	private void setConstantInField()
	{	String name = (String)mNames.getSelectedItem();
		String value = mFrame.getConstants().getValue(name).toString();
		mValue.setText(value);
	}
	
}