/******************************************************************************
  (c) Copyright 2002-2006, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: PingPongAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.2 $
  Last Modified: $Date: 2006/03/02 14:20:16 $
 *****************************************************************************/
package org.ten60.netkernel.pingpong.model;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.NKFAccessorImpl;
import com.ten60.netkernel.urii.*;
import java.util.*;
import java.awt.*;
import org.ten60.netkernel.pingpong.representation.*;
import com.ten60.netkernel.urii.aspect.*;
import java.awt.event.*;
import org.ten60.netkernel.layer1.nkf.*;

public class PingPongAccessor extends NKFAccessorImpl
{
	private static int mBatX;
	private static int mBatY;
	private static int mBatXV;
	private static int mBatYV;
	private static Rectangle mLastBat=new Rectangle();
	
    public PingPongAccessor()
    {   super(false,INKFRequestReadOnly.RQT_SOURCE|INKFRequestReadOnly.RQT_SINK);
    }
	
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	switch(context.getThisRequest().getRequestType())
		{	case INKFRequestReadOnly.RQT_SINK:
				setBatPosition(context);
				break;
			case INKFRequestReadOnly.RQT_SOURCE:
				getGameState(context);
				break;
		}
	}
	
	private void setBatPosition(INKFConvenienceHelper context) throws Exception
	{	IAspectPoint point = (IAspectPoint)context.sourceAspect(INKFRequestReadOnly.URI_SYSTEM,IAspectPoint.class);
		mBatXV = point.getX()-mBatX;
		mBatYV = point.getY()-mBatY;
		mBatX = point.getX();
		mBatY = point.getY();
	}
	
	private void getGameState(INKFConvenienceHelper context) throws Exception
	{	
		IAspectConstants constants = (IAspectConstants)context.sourceAspect("ffcpl:/pingpong/constants/current",IAspectConstants.class);
		int cWidth=constants.getValue(IAspectConstants.WALL_WIDTH).intValue();
		int cHeight=constants.getValue(IAspectConstants.WALL_HEIGHT).intValue();
		int cCount=constants.getValue(IAspectConstants.BALL_COUNT).intValue();
		int cRadius=constants.getValue(IAspectConstants.BALL_RADIUS).intValue();
		int cBatWidth=constants.getValue(IAspectConstants.BAT_WIDTH).intValue();
		int cBatHeight=constants.getValue(IAspectConstants.BAT_HEIGHT).intValue();
		
		float cWallRest=constants.getValue(IAspectConstants.BALL_WALL_RESTITUTION).floatValue();
		float cWallFric=constants.getValue(IAspectConstants.BALL_WALL_FRICTION).floatValue();
		float cBatRest=constants.getValue(IAspectConstants.BALL_BAT_RESTITUTION).floatValue();
		float cBatFric=constants.getValue(IAspectConstants.BALL_BAT_FRICTION).floatValue();
		float cRange=constants.getValue(IAspectConstants.INTERACTION_RANGE).floatValue();
		float cAttraction=constants.getValue(IAspectConstants.ATTRACTION).floatValue();
		float cRepulsion=constants.getValue(IAspectConstants.REPULSION).floatValue();
		float cBallRest=constants.getValue(IAspectConstants.BALL_BALL_RESTITUTION).floatValue();
		float cDamping=constants.getValue(IAspectConstants.DAMPING).floatValue();
		float cGravity=constants.getValue(IAspectConstants.GRAVITY).floatValue();
		
		
		BallsAspect balls=null;
		try
		{   balls = (BallsAspect)context.sourceAspect("transient:pingpong",BallsAspect.class);
			if (balls.getBalls().size()!=cCount)
			{	balls=null;
			}
		}
		catch (NKFException e) {;}
		if (balls==null)
		{	
			float cInitialSpread=constants.getValue(IAspectConstants.INITIAL_SPREAD).floatValue();
			float cInitialVelocity=constants.getValue(IAspectConstants.INITIAL_VELOCITY).floatValue();
			float cInitialRadians=constants.getValue(IAspectConstants.INITIAL_VELOCITY_RADIANS).floatValue();
			
			balls = new BallsAspect(cCount,cWidth/2,cHeight/2,cInitialSpread,cInitialVelocity,cInitialRadians);
		}

		// capture all ball positions so they are static for duration of calculation
		float[] x = new float[cCount];
		float[] y = new float[cCount];
		float[] dx = new float[cCount];
		float[] dy = new float[cCount];
		for (int i=0; i<cCount; i++)
		{   BallsAspect.Ball b=(BallsAspect.Ball)balls.getBalls().get(i);
			x[i]=b.mX;
			y[i]=b.mY;
			dx[i]=b.mDX;
			dy[i]=b.mDY;
		}

		Rectangle bat = new Rectangle(mBatX-cBatWidth/2-cRadius,mBatY-cBatHeight/2-cRadius,cBatWidth+cRadius*2,cBatHeight+cRadius*2);
				
		// mi is the maximum impact of the balls - used to determine if and how loud a
		//sound should be played
		float mi=0.0f;
		
		// interball forces
		for (int i=0; i<cCount; i++)
		{   BallsAspect.Ball b=(BallsAspect.Ball)balls.getBalls().get(i);
			float v2=b.mDX*b.mDX+b.mDY*b.mDY;
			
			float fX=0.0f;
			float fY=0.0f;
			for (int j=0; j<cCount; j++)
			{   if (j==i) continue;
				float dX = b.mX-x[j];
				float dY = b.mY-y[j];
				float d2 = dX*dX + dY*dY;
				float d = (float)Math.sqrt(d2);
				if (d<cRange)
				{
				float attraction = (d2*cAttraction)/(0.1f+d);
				float repulsion = cRepulsion/(1.0f+d2);
				float restitution = repulsion*cBallRest;
				fX+=-dX*attraction+dX*repulsion - restitution*(b.mDX-dx[j]);
				fY+=-dY*attraction+dY*repulsion - restitution*(b.mDY-dy[j]);
				}
			}
			//damping
			float df=1/(1+cDamping*v2);
			b.mDX=b.mDX*df+fX;
			b.mDY=b.mDY*df+fY;
			if (Float.isNaN(b.mDX) || Float.isInfinite(b.mDX))
			{	b.mDX=(float)Math.random()-0.5f;
			}
			if (Float.isNaN(b.mDY) || Float.isInfinite(b.mDY))
			{	b.mDY=(float)Math.random()-0.5f;
			}
			// gravity
			b.mDY+=cGravity;
			//update position with velocity
			b.mX+=b.mDX;
			b.mY+=b.mDY;
			
			
			//bounds checking
			if (b.mX<cRadius)
			{	mi=max(mi,b.mDX);
				b.mDX=cWallRest*Math.abs(b.mDX);
				b.mX=cRadius;
				b.mDY*=(1-cWallFric);
			}
			else if (b.mX>cWidth-cRadius)
			{	mi=max(mi,b.mDX);
				b.mDX=-cWallRest*Math.abs(b.mDX);
				b.mX=cWidth-cRadius;
				b.mDY*=(1-cWallFric);
			}
			if (b.mY<cRadius)
			{	mi=max(mi,b.mDY);
				b.mDY=cWallRest*Math.abs(b.mDY);
				b.mY=cRadius;
				b.mDX*=(1-cWallFric);
			}
			else if (b.mY>cHeight-cRadius)
			{	mi=max(mi,b.mDY);
				b.mDY=-cWallRest*Math.abs(b.mDY);
				b.mY=cHeight-cRadius;
				b.mDX*=(1-cWallFric);
			}			
			//bat intersection
			if (intersect(bat,(int)b.mX,(int)b.mY))
			{	int r1x = (int)b.mX-bat.x;
				int r1y = (int)b.mY-bat.y;
				int r2x = bat.width+bat.x-(int)b.mX;
				int r2y = bat.height+bat.y-(int)b.mY;
				
				
				float vx = mBatXV;
				float vy = mBatYV;
				if (r1x>r1y && r2x>r1y && r1y<bat.height/2)
				{	// top hit
					mi=max(mi,b.mDY);
					b.mY=bat.y-1;
					b.mDY=cBatRest*(vy-Math.abs(b.mDY));
					b.mDX+=vx*cBatFric;
				}
				else if (r1x>r2y && r2x>r2y && r1y>bat.height/2)
				{	// bottom hit
					mi=max(mi,b.mDY);
					b.mY=bat.y+bat.height+1;
					b.mDY=cBatRest*(vy+Math.abs(b.mDY));
					b.mDX+=vx*cBatFric;
				}
				else if (r1x<bat.width/2)
				{	// left hit
					mi=max(mi,b.mDX);
					b.mX=bat.x-1;
					b.mDX=cBatRest*(vx-Math.abs(b.mDX));
					b.mDY+=vy*cBatFric;
				}
				else
				{	//right hit
					mi=max(mi,b.mDX);
					b.mX=bat.x+bat.width+1;
					b.mDX=cBatRest*(vx+Math.abs(b.mDX));
					b.mDY+=vy*cBatFric;
				}
			}
			mLastBat=bat;
			
		}		
		
		// persist state
		context.sinkAspect("transient:pingpong",balls);
		
		IURAspect aspect = new PingPongAspect(balls, mi );
		INKFResponse response = context.createResponseFrom(aspect);
		response.setExpired();
		context.setResponse(response); 
	}

	private static float max(float aOld, float aVelocity)
	{	float abs=Math.abs(aVelocity);
		return (abs>aOld)?abs:aOld;
	}
	
	private static boolean intersect(Rectangle r, int x, int y)
	{	int x1=r.x;
		int y1=r.y;
		int x2=x1+r.width;
		int y2=y1+r.height;
		return (x>=x1 && x<x2 && y>=y1 && y<y2);
	}
	
}