/******************************************************************************
  (c) Copyright 2002-2004, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: NKDummySubmissionDriver.java,v $
  Version:       $Name:  $ $Revision: 1.6 $
  Last Modified: $Date: 2004/10/07 07:51:51 $
 *****************************************************************************/


package org.ten60.netkernel.xforms.connector;

import org.ten60.netkernel.xml.xda.*;
import org.ten60.netkernel.xml.util.*;
import org.chiba.xml.xforms.connector.*;
import org.chiba.xml.xforms.exception.*;
import org.chiba.xml.xforms.*;
import org.chiba.xml.util.*;
import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.stream.*;

import java.util.*;
import java.io.*;
import org.w3c.dom.*;
/**
 *	A dummy submission driver that wraps the submission data and URI so that the
 *	controller layer can decided how it wants to handle it.
 * @author  pjr
 */
public class NKDummySubmissionDriver implements SubmissionHandler
{	
	public static final String NK_FORWARD_PAYLOAD="NK_FORWARD_PAYLOAD";
	public static final String NK_FORWARD_URI="NK_FORWARD_URI";
	String mURI;
	Map mContext=null;
	
	
	/** Creates a new instance of NKDummySubmissionDriver */
	public NKDummySubmissionDriver()
	{
	}
	
	public void setURI(String uri)
	{	mURI=uri;
	}
	
	public java.util.Map submit(org.chiba.xml.xforms.Submission submission, org.w3c.dom.Node instance) throws org.chiba.xml.xforms.exception.XFormsException
	{	HashMap response=new HashMap(2);
		try
		{	response.put(NK_FORWARD_URI, mURI);
			DOMXDA doc=new DOMXDA((Document)instance, false);
			response.put(NK_FORWARD_PAYLOAD, doc  );
		}
		catch(Exception e)
		{	e.printStackTrace();
			throw new XFormsException(e);	
		}
		return response;
	}
	
	public String getURI()
	{	/*Return null for the moment*/
		return null;
	}	
	
	public void setContext(Map aContext)
	{	mContext=aContext;
	}
	
	public Map getContext()
	{	return mContext;		
	}
}
