/******************************************************************************
  (c) Copyright 2002-2004, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: NetKernelRequestHandler.java,v $
  Version:       $Name:  $ $Revision: 1.5 $
  Last Modified: $Date: 2005/12/23 10:08:01 $
 *****************************************************************************/

package org.ten60.netkernel.xforms.adapter;

import org.chiba.adapter.InteractionHandler;
import org.chiba.xml.xforms.events.*;
import org.chiba.xml.xforms.config.Config;
import org.chiba.xml.xforms.*;
import org.chiba.xml.xforms.ui.*;

import org.chiba.xml.xforms.exception.XFormsException;
import org.ten60.netkernel.layer1.representation.IAspectNVP;

import org.ten60.netkernel.layer1.nkf.*;
import java.util.*;

/**
 *
 * @author  pjr
 */
public class NetKernelRequestHandler implements InteractionHandler
{
	private ChibaBean mChibaBean=null;
	
	private static final String DATA_PREFIX_PROPERTY = "chiba.web.dataPrefix";
    private static final String TRIGGER_PREFIX_PROPERTY = "chiba.web.triggerPrefix";
    private static final String SELECTOR_PREFIX_PROPERTY = "chiba.web.selectorPrefix";
    private static final String DATA_PREFIX_DEFAULT = "d_";
    private static final String TRIGGER_PREFIX_DEFAULT = "t_";
    private static final String SELECTOR_PREFIX_DEFAULT = "s_";

    private ChibaBean chibaBean=null;
	private Map parameterNames = null;

	private String dataPrefix = null;
    private String triggerPrefix = null;
    private String selectorPrefix = null;
	
	/** Creates a new instance of NetKernelRequestHandler */
	public NetKernelRequestHandler(ChibaBean aChibaBean)
	{	mChibaBean=aChibaBean;
	}
	
	public void execute() throws org.chiba.xml.xforms.exception.XFormsException
	{	INKFConvenienceHelper context=(INKFConvenienceHelper) mChibaBean.getContext().get(NetKernelAdapter2.NKF_REQUEST_HELPER);
		try
		{	 handleRequest(context);
		}
		catch(Exception e)
		{	e.printStackTrace();
			throw new org.chiba.xml.xforms.exception.XFormsException(e);
		}
	}
	
	private void handleRequest(INKFConvenienceHelper context) throws Exception
	{	Map requestMap=null;
		if(context.getThisRequest().getArgument("param")!=null)
		{	IAspectNVP nvpa=(IAspectNVP)context.sourceAspect("this:param:param", IAspectNVP.class);
			requestMap = new HashMap();
			//Convert NVP to String[] RequestMap
			Iterator i = nvpa.getNames().iterator();
			while (i.hasNext()) {
				String name = (String)i.next();
				List l=nvpa.getValues(name);
				String strvalues[] = new String[l.size()];
				Iterator i2=l.iterator();
				int j=0;
				while(i2.hasNext())
				{	String value=(String)i2.next();
					strvalues[j]=value;
					j++;
				}
				requestMap.put(name, strvalues);
			}
		}
		String trigger = null;
		trigger=handleRequestInner(requestMap, trigger);
        // finally activate trigger if any
        if (trigger != null) {
            mChibaBean.dispatch(trigger, XFormsEventFactory.DOM_ACTIVATE);
        }
	}
	
	  /**
     * @param request
     * @param trigger
     * @return
     * @throws XFormsException
     */
    private String handleRequestInner(Map aRequest,  String trigger)
            throws XFormsException {
        // iterate request parameters
        Iterator it = aRequest.keySet().iterator();
		
        while (it.hasNext()) {
            String paramName = (String)it.next();
            String[] values = (String [])aRequest.get(paramName);

            
            // [1] handle data
            handleData(paramName, values);

            // [3] handle selector
            handleSelector(paramName, values[0]);

            // [2] handle trigger
            trigger = handleTrigger(trigger, paramName);
        }
        return trigger;
    }

    /**
     * @param name
     * @throws XFormsException
     */
    private void handleSelector (String name, String value) throws XFormsException {
        if (name.startsWith(getSelectorPrefix())) {
            int separator = value.lastIndexOf(':');

            String id = value.substring(0, separator);
            int index = Integer.valueOf(value.substring(separator + 1)).intValue();

            Repeat repeat = (Repeat) mChibaBean.getContainer().lookup(id);
            repeat.setIndex(index);
        }
    }

    /**
     * @param trigger
     * @param name
     * @return
     */
    private String handleTrigger(String trigger, String name) {
        if ((trigger == null) && name.startsWith(getTriggerPrefix())) {
            String parameter = name;
            int x = parameter.lastIndexOf(".x");
            int y = parameter.lastIndexOf(".y");

            if (x > -1) {
                parameter = parameter.substring(0, x);
            }

            if (y > -1) {
                parameter = parameter.substring(0, y);
            }

            // keep trigger id
            trigger = name.substring(getTriggerPrefix().length());
        }
        return trigger;
    }


    /**
     * @param name
     * @throws XFormsException
     */
    private void handleData(String name, String[] values)
            throws XFormsException {
        if (name.startsWith(getDataPrefix())) {
            String id = name.substring(getDataPrefix().length());

            // assemble new control value
            String newValue;

            if (values.length > 1) {
                StringBuffer buffer = new StringBuffer(values[0]);

                for (int i = 1; i < values.length; i++) {
                    buffer.append(" ").append(values[i]);
                }

                newValue = buffer.toString().trim();
            } else {
                newValue = values[0];
            }

            mChibaBean.updateControlValue(id, newValue);
        }
    }
	
	
	public String getDataPrefix () {
        if (this.dataPrefix == null) {
            try {
                this.dataPrefix = Config.getInstance().getProperty(DATA_PREFIX_PROPERTY, DATA_PREFIX_DEFAULT);
            }
            catch (Exception e) {
                this.dataPrefix = DATA_PREFIX_DEFAULT;
            }
        }

        return this.dataPrefix;
    }

    public String getTriggerPrefix () {
        if (this.triggerPrefix == null) {
            try {
                this.triggerPrefix = Config.getInstance().getProperty(TRIGGER_PREFIX_PROPERTY, TRIGGER_PREFIX_DEFAULT);
            }
            catch (Exception e) {
                this.triggerPrefix = TRIGGER_PREFIX_DEFAULT;
            }
        }

        return this.triggerPrefix;
    }

    public String getSelectorPrefix () {
        if (this.selectorPrefix == null) {
            try {
                this.selectorPrefix = Config.getInstance().getProperty(SELECTOR_PREFIX_PROPERTY, SELECTOR_PREFIX_DEFAULT);
            }
            catch (Exception e) {
                this.selectorPrefix = SELECTOR_PREFIX_DEFAULT;
            }
        }

        return this.selectorPrefix;
    }
}
