/******************************************************************************
  (c) Copyright 2002-2004, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: ControllerAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.3 $
  Last Modified: $Date: 2006/01/18 18:18:01 $
 *****************************************************************************/

package org.ten60.netkernel.xforms.accessor;

import org.ten60.netkernel.layer1.nkf.*;
import org.ten60.netkernel.layer1.nkf.impl.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.*;
import org.ten60.netkernel.layer1.representation.*;
/**
 *
 * @author  pjr
 */
public class ControllerAccessor extends NKFAccessorImpl
{
	
	/** Creates a new instance of ControllerAccessor */
	public ControllerAccessor()
	{	super(4, true, INKFRequestReadOnly.RQT_SOURCE);
	}
	
	public void processRequest(INKFConvenienceHelper context) throws Exception
	{	IURRepresentation rep=context.source("this:param:param");
		if(rep.hasAspect(IAspectString.class))
		{	//It's a forward
			IAspectMultipart mp =(IAspectMultipart)rep.getAspect(IAspectMultipart.class);
			IURRepresentation uripart=mp.getPartWithName("uri");
			IAspectString sa=(IAspectString)uripart.getAspect(IAspectString.class);
			String uri=sa.getString();
			IURRepresentation docpart=mp.getPartWithName("document");
			//Create and issue forard request
			INKFRequest req=context.createSubRequest();
			req.setURI(uri);
			req.addArgument("session", context.getThisRequest().getArgument("session"));
			req.addArgument("param", docpart);
			IURRepresentation result=context.issueSubRequest(req);
			//Issue response
			INKFResponse resp=context.createResponseFrom(result);
			context.setResponse(resp);
			
			//Finally delete XForm from session
			String sessionXFormURI=context.getThisRequest().getArgument("param");
			context.delete(sessionXFormURI);
		}
		else
		{	//Style the form
			INKFRequest req=context.createSubRequest();
			String uri=null;
			uri = context.getThisRequest().argumentExists("compiled") ? "active:xsltc" : "active:xslt" ;
			req.setURI(uri);
			req.addArgument("operand", rep);
			req.addArgument("operator", context.source("this:param:xslt"));
			IURRepresentation result=context.issueSubRequest(req);
			INKFResponse resp=context.createResponseFrom(result);
			context.setResponse(resp);
		}
	}
	
}
