<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0"
    xmlns:xhtml="http://www.w3.org/2002/06/xhtml2"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:xforms="http://www.w3.org/2002/xforms"
    xmlns:xlink="http://www.w3.org/1999/xlink"
    xmlns:chiba="http://chiba.sourceforge.net/xforms"
	xmlns:xrl="http://1060.org/xrl"
    exclude-result-prefixes="xhtml xforms chiba xlink">
	
	<xsl:include href="/org/chiba/xslt/ui.xsl"/>
    <xsl:include href="/org/chiba/xslt/html-form-controls.xsl"/>

    <!-- ####################################################################################################### -->
    <!-- This stylesheet transcodes a XTHML2/XForms input document to HTML 4.0.                                  -->
    <!-- It serves as a reference for customized stylesheets which may import it to overwrite specific templates -->
    <!-- or completely replace it.                                                                               -->
    <!-- This is the most basic transformator for HTML browser clients and assumes support for HTML 4 tagset     -->
    <!-- but does NOT rely on javascript.                                                                        -->
    <!-- author: joern turner                                                                                    -->
    <!-- ####################################################################################################### -->

    <!-- ####################################################################################################### -->
    <!-- This is a modified html4.xsl for use by NetKernel                                                       -->
    <!--     the changes are to output xml and                                                                   -->
    <!--     to remove any templates that match xhtml things such as /, html, head, etc and                      -->
    <!--     delete unused params - action-url, css                                                              -->
    <!--     added a template named build-form to  output the html form construct                                -->
    <!-- ####################################################################################################### -->

    <!-- ### signals the phase of processing (init|submit) ### -->
    <xsl:param name="phase" select="'false'"/>

    <xsl:param name="form-id" select="'chiba-form'"/>
    <xsl:param name="form-name" select="'Chiba XForms Processor'"/>
    <xsl:param name="debug-enabled" select="false()"/>

    <!-- ### specifies the parameter prefix for repeat selectors ### -->
    <xsl:param name="selector-prefix" select="'s_'"/>

    <!-- ### checks, whether this form uses uploads. Used to set form enctype attribute ### -->
    <xsl:variable name="uses-upload" select="boolean(//*/xforms:upload)"/>
	<xsl:variable name="user-agent" select="default"/>
	
    <xsl:output method="xml"/>

    <!-- ### transcodes the XHMTL namespaced elements to HTML ### -->
    <!--xsl:namespace-alias stylesheet-prefix="xhtml" result-prefix="#default"/-->

    <xsl:preserve-space elements="*"/>
    <xsl:strip-space elements="xforms:action"/>

<!-- ####################################################################################################### -->
    <!-- ##################################### TEMPLATES ####################################################### -->
    <!-- ####################################################################################################### -->

    <xsl:template match="/">
		<xsl:apply-templates select="/descendant::form"/>
	</xsl:template>
	
    <!-- copy unmatched mixed markup, comments, whitespace, and text -->
    <!-- ### copy elements from the xhtml2 namespace to html (without any namespace) by re-creating the     ### -->
    <!-- ### elements. Other Elements are just copied.                                                      ### -->
    <xsl:template match="*|@*|text()">
        <xsl:choose>
            <xsl:when test="namespace-uri(.)='http://www.w3.org/2002/06/xhtml2'">
                <xsl:element name="{local-name(.)}">
                    <xsl:apply-templates select="*|@*|text()"/>
                </xsl:element>
            </xsl:when>
			<xsl:otherwise>
                <xsl:copy>
                    <xsl:apply-templates select="*|@*|text()"/>
                </xsl:copy>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
	
	    <!-- build form skeleton -->
    <xsl:template name="build-form">
		<xsl:param name="action-uri"/>
        <xsl:if test="$debug-enabled=true()">
            <xsl:message>form-std: Doing build-form</xsl:message>
        </xsl:if>

        <xsl:element name="form">
          <xsl:attribute name="name">
            <xsl:value-of select="$form-id"/>
          </xsl:attribute>
          <xsl:attribute name="action">
            <xsl:value-of select="$action-uri"/>
          </xsl:attribute>
          <xsl:attribute name="method">POST</xsl:attribute>
          <xsl:attribute name="enctype">application/x-www-form-urlencoded</xsl:attribute>
          <xsl:if test="$uses-upload">
            <xsl:attribute name="enctype">multipart/form-data</xsl:attribute>
          </xsl:if>
          <!-- Added for NetKernel -->
          <xsl:attribute name="xrl:resolve">action</xsl:attribute>
          
          <!-- provide a first submit which does not map to any xforms:trigger -->
          <!--<input type="image" name="dummy" style="width:0px; height:0px; border: 0px; background-color: red;" value="dummy"/>-->
          <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    
    <xsl:template match="xhtml:span">
        <span>
            <xsl:copy-of select="@xhtml:class"/>
            <xsl:apply-templates/>
        </span>
    </xsl:template>

    <!-- ### skip explicitely disabled control ### -->
	<xsl:template match="*[chiba:data/@chiba:enabled='false']">
		<xsl:if test="$debug-enabled=true()">
			<xsl:message>skipping disabled control</xsl:message>
		</xsl:if>
	</xsl:template>

    <!-- ### skip chiba:data elements ### -->
    <xsl:template match="chiba:data"/>

    <!-- ### skip model section ### -->
    <xsl:template match="xforms:model"/>

    
    <!-- ######################################################################################################## -->
    <!-- #####################################  CONTROLS ######################################################## -->
    <!-- ######################################################################################################## -->

    <!-- ### handle xforms:input ### -->
    <xsl:template match="xforms:input">
        <xsl:call-template name="buildControl"/>
    </xsl:template>

    <!-- ### handle xforms:output ### -->
    <xsl:template match="xforms:output">
        <xsl:call-template name="buildControl"/>
    </xsl:template>

    <!-- ### handle xforms:range ### -->
    <xsl:template match="xforms:range">
        <xsl:call-template name="buildControl"/>
    </xsl:template>

    <!-- ### handle xforms:secret ### -->
    <xsl:template match="xforms:secret">
        <xsl:call-template name="buildControl"/>
    </xsl:template>

    <!-- ### handle xforms:select ### -->
    <xsl:template match="xforms:select">
        <xsl:call-template name="buildControl"/>
    </xsl:template>

    <!-- ### handle xforms:select1 ### -->
    <xsl:template match="xforms:select1">
        <xsl:call-template name="buildControl"/>
    </xsl:template>

    <!-- ### handle xforms:submit ### -->
    <xsl:template match="xforms:submit">
        <xsl:call-template name="buildControl"/>
    </xsl:template>

    <!-- ### handle xforms:trigger ### -->
    <xsl:template match="xforms:trigger">
        <xsl:call-template name="buildControl"/>
    </xsl:template>

    <!-- ### handle xforms:textarea ### -->
    <xsl:template match="xforms:textarea">
        <xsl:call-template name="buildControl"/>
    </xsl:template>

    <!-- ### handle xforms:upload ### -->
    <xsl:template match="xforms:upload">
        <xsl:call-template name="buildControl"/>
    </xsl:template>

    <!-- ### this template must be provided since its called from the imported html-form-controls.xsl ### -->
<!--
    <xsl:template name="eval-actions">
        <xsl:if test="xforms:insert|xforms:delete">
            <xsl:attribute name="onClick">javascript:
                <xsl:apply-templates select="xforms:insert|xforms:delete"/>return true;
            </xsl:attribute>
        </xsl:if>
    </xsl:template>
-->

    <!-- ### triggers must handle their label themselves ### -->
    <xsl:template match="xforms:trigger/xforms:label"/>

    <!-- ### handle label ### -->
    <xsl:template match="xforms:label">
        <xsl:variable name="group-id" select="ancestor::xforms:group[1]/@id"/>
        <xsl:variable name="img" select="@xforms:src"/>

        <xsl:choose>
            <xsl:when test="name(..)='xforms:group'">
                <xsl:apply-templates/>
            </xsl:when>
            <xsl:when test="name(..)='xforms:item'">
                <span id="{@id}" class="label">
                    <xsl:apply-templates/>
                </span>
            </xsl:when>
            <xsl:when test="boolean($img) and ( contains($img,'.gif') or contains($img,'.jpg') or contains($img,'.png') )">
                <img src="{$img}" id="{@id}-label" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- ### handle hint ### -->
    <xsl:template match="xforms:hint">
        <!--  already handled by individual controls in html-form-controls.xsl -->
    </xsl:template>

    <!-- ### handle help ### -->
    <!-- ### only reacts on help elements with a 'src' attribute and interprets it as html href ### -->
    <xsl:template match="xforms:help">
        ?
        <!--
                <span style="font-color:blue;vertical-align:top;padding-left:2px;font-weight:bold">
                    <xsl:if test="@xforms:src">
                        <a href="{@xforms:src}">?</a>
                    </xsl:if>
                </span>
        -->
        <!--        <img src="images/kasten_blau.gif"/>-->
        <!-- this implementation renders a button to display a javascript message -->
        <!--        <img src="images/help.gif" onClick="javascript:xf_help('{normalize-space(.)}');return true;"/>-->
    </xsl:template>

      <!-- ### handle explicitely enabled alert ### -->
    <xsl:template match="xforms:alert[../chiba:data/@chiba:valid='false' or ../chiba:data/@chiba:visited='false']">
			<span id="{../@id}-alert" class="alert">
				<xsl:value-of select="."/>
			</span>
    </xsl:template>
	<xsl:template match="xforms:alert">
		<!--Do nothing if valid-->
	</xsl:template>

    <!-- ### handle extensions ### -->
    <xsl:template match="xforms:extension">
        <xsl:apply-templates/>
    </xsl:template>

    <xsl:template match="chiba:selector">
    </xsl:template>


    <!-- ########################## ACTIONS ####################################################### -->
    <!-- these templates serve no real purpose here but are shown for reference what may be over-   -->
    <!-- written by customized stylesheets importing this one. -->
    <!-- ########################## ACTIONS ####################################################### -->

    <!-- action nodes are simply copied to output without any modification -->
    <xsl:template match="xforms:action">
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="xforms:dispatch"/>
    <xsl:template match="xforms:rebuild"/>
    <xsl:template match="xforms:recalculate"/>
    <xsl:template match="xforms:revalidate"/>
    <xsl:template match="xforms:refresh"/>
    <xsl:template match="xforms:setfocus"/>
    <xsl:template match="xforms:load"/>
    <xsl:template match="xforms:setvalue"/>
    <xsl:template match="xforms:send"/>
    <xsl:template match="xforms:reset"/>
    <xsl:template match="xforms:message"/>
    <xsl:template match="xforms:toggle"/>
    <xsl:template match="xforms:insert"/>
    <xsl:template match="xforms:delete"/>
    <xsl:template match="xforms:setindex"/>


    <!-- ####################################################################################################### -->
    <!-- #####################################  HELPER TEMPLATES '############################################## -->
    <!-- ####################################################################################################### -->

    <xsl:template name="buildControl">
        <xsl:if test="$debug-enabled=true()">
            <xsl:message>buildControl:
                <xsl:value-of select="name(.)"/>
            </xsl:message>
        </xsl:if>
		<xsl:choose>
            <xsl:when test="local-name()='input'">
                <xsl:call-template name="input"/>
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='output'">
                <xsl:call-template name="output"/>
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='range'">
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='secret'">
                <xsl:call-template name="secret"/>
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='select'">
                <xsl:call-template name="select"/>
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='select1'">
                <xsl:call-template name="select1"/>
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='submit'">
                <xsl:call-template name="submit"/>
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='trigger'">
                <xsl:call-template name="trigger"/>
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='textarea'">
                <xsl:call-template name="textarea"/>
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='upload'">
                <xsl:call-template name="upload"/>
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='repeat'">
                <xsl:apply-templates select="."/>
            </xsl:when>
            <xsl:when test="local-name()='group'">
                <xsl:apply-templates select="."/>
                <xsl:apply-templates select="xforms:help"/>
                <xsl:apply-templates select="xforms:alert"/>
            </xsl:when>
            <xsl:when test="local-name()='switch'">
                <xsl:apply-templates select="."/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>

    <!-- ***** builds a string containing the correct css-classes reflecting UI-states like
    readonly/readwrite, enabled/disabled, valid/invalid ***** -->
    <xsl:template name="assembleClasses">

        <!-- only execute if there's a data element which is e.g. not the case for unbound groups -->
        <xsl:if test="chiba:data">
            <xsl:variable name="valid">
                <xsl:choose>
                    <xsl:when test="string-length(chiba:data) = 0 and chiba:data/@chiba:visited='false'">valid</xsl:when>
                    <xsl:when test="chiba:data/@chiba:valid='true'">valid</xsl:when>
                    <xsl:otherwise>invalid</xsl:otherwise>
                </xsl:choose>
            </xsl:variable>

            <xsl:variable name="readonly">
                <xsl:choose>
                    <xsl:when test="chiba:data/@chiba:readonly='true'">readonly</xsl:when>
                    <xsl:otherwise>readwrite</xsl:otherwise>
                </xsl:choose>
            </xsl:variable>

            <xsl:variable name="required">
                <xsl:choose>
                    <xsl:when test="chiba:data/@chiba:required='true'">required</xsl:when>
                    <xsl:otherwise>optional</xsl:otherwise>
                </xsl:choose>
            </xsl:variable>

            <xsl:variable name="enabled">
                <xsl:choose>
                    <xsl:when test="chiba:data/@chiba:enabled='true'">enabled</xsl:when>
                    <xsl:otherwise>disabled</xsl:otherwise>
                </xsl:choose>
            </xsl:variable>

            <xsl:value-of select="concat(' ',$valid,' ',$readonly,' ',$required, ' ', $enabled)"/>
        </xsl:if>
    </xsl:template>

    <xsl:template name="labelClasses">

        <!-- only execute if there's a data element which is e.g. not the case for unbound groups -->
        <xsl:choose>
            <xsl:when test="chiba:data">
                <xsl:variable name="enabled">
                    <xsl:choose>
                        <xsl:when test="chiba:data/@chiba:enabled='true'">enabled</xsl:when>
                        <xsl:otherwise>disabled</xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                <xsl:value-of select="concat('label ',$enabled)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="'label'"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="selectorName">
        <xsl:variable name="repeat-id" select="ancestor-or-self::xforms:repeat/@id" xmlns:xforms="http://www.w3.org/2002/xforms"/>
        <xsl:value-of select="concat($selector-prefix, $repeat-id)"/>
    </xsl:template>
	
</xsl:stylesheet>




