/*
	PiNKY Project : Execute Yahoo Pipelines on 1060 NetKernel!
    Copyright (C) 2007  Peter Rodgers

	GPL License Notice:
	
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
	
	1060 Public License Notice:
	 * This Software is licensed to You, the licensee, for use under the terms of
	 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
	 * License v1.0 [www.1060research.com/license] before using or redistributing
	 * this software.
	 *
	 * In summary the 1060 Public license has the following conditions.
	 * A. You may use the Software free of charge provided you agree to the terms
	 * laid out in the 1060 Public License v1.0
	 * B. You are only permitted to use the Software with components or applications
	 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
	 * for which licensing has been approved by 1060 Research Limited.
	 * You may write your own software for execution by this Software provided any
	 * distribution of your software with this Software complies with terms set out
	 * in section 2 of the 1060 Public License v1.0
	 * C. You may redistribute the Software provided you comply with the terms of
	 * the 1060 Public License v1.0 and that no warranty is implied or given.
	 * D. If you find you are unable to comply with this license you may seek to
	 * obtain an alternative license from 1060 Research Limited by contacting
	 * license@1060research.com or by visiting www.1060research.com
	 *
	 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
	 * LICENSE V1.0 FOR DETAILS
	 *
	 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
	 * THE DISTRIBUTED license.txt OR www.1060research.com/license

*/
package org.pinkypipes.accessor;

import org.pinkypipes.aspect.FeedAspect;
import org.pinkypipes.aspect.IAspectFeed;
import org.ten60.netkernel.layer1.nkf.impl.NKFAccessorImpl;
import org.ten60.netkernel.layer1.nkf.INKFConvenienceHelper;
import org.ten60.netkernel.layer1.nkf.INKFRequestReadOnly;
import org.ten60.netkernel.layer1.nkf.INKFRequest;
import org.ten60.netkernel.layer1.nkf.INKFResponse;
import org.ten60.netkernel.xml.representation.IXAspect;
import org.ten60.netkernel.xml.representation.DOMXDAAspect;
import org.ten60.netkernel.xml.xda.DOMXDA;
import org.ten60.netkernel.xml.xda.IXDAReadOnly;
import org.ten60.netkernel.xml.xda.IXDAReadOnlyIterator;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.feed.synd.SyndEntry;
import com.ten60.netkernel.util.NetKernelException;
import com.ten60.netkernel.urrequest.URRequest;
import com.ten60.netkernel.urii.IURRepresentation;

/**
 * FetchAccessor - Obtains a feed based on parameters.
 * @author  rsk
 */
public class FetchAccessor extends NKFAccessorImpl
  {

	/** Creates a new instance of UniqueAccessor */
	public FetchAccessor()
	{	super(SAFE_FOR_CONCURRENT_USE, INKFRequestReadOnly.RQT_SOURCE);
	}

  /**
   * Given an XML document with feeds elements containing one or more
   * url elements. For each url element, will obtains feed information
   * and add it to the total set of feeds.
   *
   * @param context
   * @throws Exception
   */
  public void processRequest(INKFConvenienceHelper context) throws Exception
    {
    INKFRequest request;

    SyndFeed feed = null;
    SyndFeed feedMain = null;
    List     mainFeedList = null;

    IAspectFeed feedAspect = null;
    IAspectFeed feedMainAspect = null;
    boolean firstFeed = true;

    IXAspect feeds = (IXAspect)context.sourceAspect("this:param:feeds",IXAspect.class);

    IXDAReadOnly roDoc = feeds.getXDA();
    IXDAReadOnlyIterator iter = roDoc.readOnlyIterator("/feeds/url");
    String url = null;

    // NB: Check for no parameter and no url values
    
    while(iter.hasNext())
      {
      iter.next();
      url = iter.getText(".",true);

      // Create sub-request to get the feed information
      request = context.createSubRequest("active:httpGet");
      request.setRequestType(URRequest.RQT_SOURCE);
      request.addArgument("url", url);
      request.setAspectClass(IAspectFeed.class);
      feedAspect = (IAspectFeed)context.issueSubRequest(request).getAspect(IAspectFeed.class);
      
      if (firstFeed)
        {
        feedMain = feedAspect.getFeed();
        mainFeedList = feedMain.getEntries();
        firstFeed = false;
        }
      else
        {
        // Add the entries from this feed to the main one
        feed = feedAspect.getFeedExpertsOnly();
        Iterator it = feed.getEntries().iterator();
        while(it.hasNext())
          {
          Object e = it.next();
          mainFeedList.add(e);
          }
        }
      }


    // Create the response
    FeedAspect fa=new FeedAspect(feedMain);
    context.createResponseFrom(fa);
    }
}
