/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: CompoundURIdentifier.java,v $
 * Version:       $Name:  $ $Revision: 1.6 $
 * Last Modified: $Date: 2004/09/08 14:51:00 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.util;

import com.ten60.netkernel.urii.URIdentifier;
import java.util.*;
import java.net.URI;

/**
 * Breaks a compound URI up into its parts for processing.
 * Completely static class with static methods.
 */
public class CompoundURIdentifier
{
    /**  fixed name for one of the name value pairs
     */
    public static final String OPT="operator";
    public static final String OPD="operand";
	public static final String OPERATOR="operator";
	public static final String OPERAND="operand";
    public static final String PARAM="param";
    public static final String CWU = "cwu";
	
	public final class CompoundURIStruct
	{	private String mKey;
		private String mURI;
		public CompoundURIStruct(String aKey, String aURI)
		{	mKey=aKey;
			mURI=aURI;
		}
		public String getKey()
		{	return mKey;
		}
		public String getURI()
		{	return mURI;
		}
	};
	
	private String mScheme;
	private String mType;
	private ArrayList mArgs;
	
	public CompoundURIdentifier(String aScheme, String aType)
	{	mScheme=aScheme;
		mType=aType;
	}
	
	public CompoundURIdentifier(URIdentifier aURI)
	{	mScheme = aURI.getScheme();
		String content = aURI.getSchemeSpecificPart();
		int length = content.length();
		int i=0;
		int i2,i3;

		i2 = content.indexOf('+',i);
		if (i2<0) i2=length;
		mType=content.substring(i,i2);
		i=i2+1;

		while (i<length)
		{	i2 = content.indexOf('@',i);
			if (i2>=0)
			{	String key = content.substring(i,i2);
				i3 = content.indexOf('+',i2);
				if (i3<0) i3 = length;
				String uri = content.substring(i2+1,i3);
				String uri2 = decode(uri);
				addArg(key,uri2);
				i=i3+1;
			}
			else
			{	break;
			}
		}
	}
	
	public static boolean isCompound(URIdentifier aURI)
	{	String content = aURI.getSchemeSpecificPart();
		int i1=content.indexOf('+');
		int i2=content.indexOf('@');
		return i1>0 && i2>0 && i1<i2;
	}
	
	
	public void replaceArg(String aKey, String aURI)
	{	if (mArgs!=null)
		{	// remove any existing value
			for (Iterator i = mArgs.iterator(); i.hasNext(); )
			{	CompoundURIStruct struct = (CompoundURIStruct)i.next();
				if (struct.getKey().equals(aKey))
				{	i.remove();
					break;
				}
			}
		}
		addArg(aKey, aURI);
	}
	
	public void addArg(String aKey, String aURI)
	{	if (mArgs==null)
		{	mArgs = new ArrayList(4);
		}
		CompoundURIStruct struct = new CompoundURIStruct(aKey,aURI);
		if (aKey.equals(OPD))
		{	mArgs.add(0,struct);
		}
		else
		{	mArgs.add(struct);
		}
	}
	
	public String getScheme()
	{	return mScheme;
	}
	
	public String getType()
	{	return mType;
	}
	
	/** Returns an iterator over a set of CompoundURIdentifier.CompoundURIStruct */
	public Iterator getArgs()
	{	Iterator result;
		if (mArgs==null)
		{	result = Collections.EMPTY_LIST.iterator();
		}
		else
		{	result = mArgs.iterator();
		}
		return result;
	}
	
	public String get(String aKey)
	{	String result=null;
		if (mArgs!=null)
		{	for (Iterator i = mArgs.iterator(); i.hasNext(); )
			{	CompoundURIStruct struct = (CompoundURIStruct)i.next();
				if (struct.getKey().equals(aKey))
				{	result = struct.getURI();
					break;
				}
			}
		}
		return result;
	}
	
	
	public String toString()
	{	StringBuffer sb=new StringBuffer(128);
		sb.append(mScheme);
		sb.append(':');
		sb.append(mType);
		if (mArgs!=null)
		{	for (Iterator i=mArgs.iterator(); i.hasNext(); )
			{	CompoundURIStruct struct = (CompoundURIStruct)i.next();
				sb.append('+');
				sb.append(struct.getKey());
				sb.append('@');
				sb.append(encode(struct.getURI()));
			}
		}
		return new String(sb);
	}
	
	public URIdentifier toURI()
	{	return new URIdentifier(toString());
	}
	
	public URI toJavaURI()
	{	return URI.create(toString());
	}
	
	public static String decode(String aInput)
	{	StringBuffer sb=new StringBuffer(aInput.length());
		int length = aInput.length();
		for (int i=0; i<length; i++)
		{	char c = aInput.charAt(i);
			char r=c;
			if (c=='%')
			{	int c1 = toHex(aInput.charAt(++i));
				int c2 = toHex(aInput.charAt(++i));
				char r2 = (char)((c1<<4) + c2);
				switch (r2)
				{	case ' ':
					case '%':
					case ':':
					case '#':
					case '+':
					case '@':
					case '=':
						r=r2;
						break;
					default:
						i-=2;
						break;
				}
			}
			sb.append(r);
		}
		return new String(sb);
	}
	
	private static int toHex(char aChar)
	{	int result=0;
		if (aChar<='9' && aChar>='0')
		{	result = aChar-'0';
		}
		else if (aChar<='Z' && aChar>='A')
		{	result= aChar-('A'-10);
		}
		return result;
	}
	
	public static String encode(String aInput)
	{	StringBuffer sb=new StringBuffer(aInput.length()*3/2);
		int length = aInput.length();
		for (int i=0; i<length; i++)
		{	char c = aInput.charAt(i);
			switch (c)
			{	case ' ': sb.append("%20"); break;
				case '%': sb.append("%25"); break;
				case ':': sb.append("%3A"); break;
				case '#': sb.append("%23"); break;
				case '+': sb.append("%2B"); break;
				case '@': sb.append("%40"); break;
				case '=': sb.append("%3D"); break;
				default: sb.append(c);
			}
		}
		return new String(sb);
	}	
}