/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: NKFTransportImpl.java,v $
 * Version:       $Name:  $ $Revision: 1.4 $
 * Last Modified: $Date: 2004/09/01 13:09:21 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.nkf.impl;

import org.ten60.netkernel.layer1.nkf.*;
import com.ten60.netkernel.transport.*;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.container.Container;
import com.ten60.netkernel.util.NetKernelException;
/**
 * Base class for developing NetKernel Transports on the NKF API
 * @author  tab
 */
public abstract class NKFTransportImpl implements ITransport
{
	private Container mContainer;
	private IRequestorContext mRequestorContext;
	private NKFTransportHelperImpl mContext;
	
	public final  void setContext(IRequestorContext aRequestorContext)
	{	mRequestorContext=aRequestorContext;
		mContext = new NKFTransportHelperImpl(mContainer,mRequestorContext,this);
	}
	
	/**
	 * Low-level transport start, performs NKF-speocific inititialisation
	 */
	public final void start(Container aContainer, IRequestorContext aRequestorContext) throws NetKernelException
	{	mContainer=aContainer;
		setContext(aRequestorContext);
		try
		{	startTransport();
		}
		catch (Exception e)
		{	String message = this.getClass().toString()+" in module "+mContext.toString()+" failed to start";
			NetKernelException ex=new NetKernelException("Failed to start Transport",message,null);
			ex.addCause(e);
			throw ex;
		}
	}
	
	/**
	 *  Called when the transport is started by the Kernel
	 */
	protected abstract void startTransport() throws Exception;
	
	/**
	 * Low-level transport stop, performs NKF-speocific shutdown
	 */
	public final  void stop() throws NetKernelException
	{	try
		{	stopTransport();
		}
		catch (Exception e)
		{	String message = this.getClass().toString()+" in module "+mContext.toString()+" failed to stop";
			NetKernelException ex=new NetKernelException("Failed to stop Transport",message,null);
			ex.addCause(e);
			throw ex;
		}
	}
	
	/**
	 *  Called when the transport is stopped by the Kernel
	 */
	protected abstract void stopTransport() throws Exception;
	
	/**
	 *  Get an INKFConvenienceHelper context object through which to interact with the Kernel.
	 * 
	 */
	protected final INKFConvenienceHelper getContext()
	{	return mContext;
	}
}