/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: NKFResponseImpl.java,v $
 * Version:       $Name:  $ $Revision: 1.6 $
 * Last Modified: $Date: 2004/09/03 14:25:34 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.nkf.impl;

import org.ten60.netkernel.layer1.nkf.*;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.urii.*;
import org.ten60.netkernel.layer1.util.CompoundURIdentifier;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.representation.*;
import java.net.URI;
import java.util.*;
/**
 * Wrapper around the setting of a response from the invocation of an accessor
 * @author  tab
 */
public class NKFResponseImpl implements INKFResponse
{
	private List mAspects;
	private boolean mCacheable;
	private int mCreationCost;
	private int mUsageCost;
	private long mExpiry=-1;
	private String mMimetype = "content/unknown";
	private NKFHelperImpl mHelper;
	
	/** Creates a new instance of NKFResponseImpl */
	public NKFResponseImpl(IURRepresentation aRep, NKFHelperImpl aHelper)
	{	mAspects = new ArrayList(aRep.getAspects());
		mHelper=aHelper;
		mMimetype = aRep.getMeta().getMimeType();
	}
	/** Creates a new instance of NKFResponseImpl */
	public NKFResponseImpl(IURAspect aAspect, NKFHelperImpl aHelper)
	{	mAspects = new ArrayList(2);
		mAspects.add(aAspect);
		mHelper=aHelper;
	}
	
	IURRepresentation getResponse()
	{	IURMeta meta;
		if (mExpiry==0)
		{	meta = new AlwaysExpiredMeta(mMimetype,mCreationCost);
		}
		else if (mExpiry>0)
		{	TimedExpiryMeta m = new TimedExpiryMeta(mMimetype,System.currentTimeMillis()+mExpiry,mCreationCost);
			meta = m;
		}
		else
		{	DependencyMeta m = new DependencyMeta(mMimetype,mCreationCost,mUsageCost);
			m.setIntermediate(!mCacheable);
			mHelper.addDependencies(m);
			meta = m;
		}
		IURRepresentation result;
		if (mAspects==null)
		{	result=null;
		}
		else if (mAspects.size()>1)
		{	MultiRepresentationImpl r = new MultiRepresentationImpl(meta,mAspects.size());
			for (Iterator i=mAspects.iterator(); i.hasNext(); )
			{	r.addAspect((IURAspect)i.next());
			}
			result = r;
		}
		else 
		{	result = new MonoRepresentationImpl(meta,(IURAspect)mAspects.get(0));
		}
		return result;
	}
	
	public void setCacheable()
	{	mCacheable = true;
	}
	
	public void setCreationCost(int aCost)
	{	if (aCost<0) throw new IllegalArgumentException("aCost is negative in setCreationCost()");
		mCreationCost = aCost;
	}
	
	public void setExpired()
	{	mExpiry=0;
	}
	
	public void setExpiryPeriod(long aPeriod)
	{	if (aPeriod<0) throw new IllegalArgumentException("aPeriod is negative in setExpiryPeriod()");
		mExpiry = aPeriod;
	}
	
	public void setMimeType(String aType)
	{	if (aType==null) throw new IllegalArgumentException("aType is null in setMimeType()");
		mMimetype=aType;
	}
	
	public void setUsageCost(int aCost)
	{	if (aCost<0) throw new IllegalArgumentException("aCost is negative in setUsageCost()");
		mUsageCost=aCost;
	}	
	
	public void addAspect(IURAspect aAspect)
	{	mAspects.add(aAspect);
	}
}