/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: NKFRequestImpl.java,v $
 * Version:       $Name:  $ $Revision: 1.24 $
 * Last Modified: $Date: 2004/10/22 11:30:49 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.nkf.impl;

import com.ten60.netkernel.util.CheapMap;

import org.ten60.netkernel.layer1.nkf.*;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.module.ModuleDefinition;
import org.ten60.netkernel.layer1.util.CompoundURIdentifier;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.util.*;
import java.net.URI;
import java.util.*;

/**
 * Wrapper around the construction of a sub-request from within an accessor
 * @author  tab
 */
public class NKFRequestImpl implements INKFRequest
{
	private NKFRequestReadOnlyImpl mParentRequest;
	private ModuleDefinition mContext;
	private int mType = URRequest.RQT_SOURCE;
	private String mBaseURI;
	private String mFragment;
	private String mCWU;
	private Class mAspectClass = IURAspect.class;
	private Map mValues = new CheapMap(8);
	private Map mURIs = new CheapMap(8);
	
	/** Creates a new instance of NKFRequestImpl */
	public NKFRequestImpl(NKFRequestReadOnlyImpl aParentRequest, ModuleDefinition aContext, String aCWU)
	{	mParentRequest = aParentRequest;
		mContext = aContext;
		mCWU = aCWU;
	}
	
	URRequest getKernelRequest()
	{	
		// determine URI
		if (mBaseURI==null) throw new IllegalArgumentException("No URI specified in request");
		
		// construct request
		URIdentifier cwu=null;
		if (mCWU!=null)
		{	cwu = new URIdentifier(mCWU);
		}
		
		String uriString;
		if (mURIs.size()>0)
		{	CompoundURIdentifier curi = new CompoundURIdentifier(new URIdentifier(mBaseURI.toString()));
			for (Iterator i=mURIs.keySet().iterator(); i.hasNext(); )
			{	String name = (String)i.next();
				String argUriString=(String)mURIs.get(name);
				curi.addArg(name, argUriString);
			}
			uriString = curi.toString();
		}
		else
		{	uriString = mBaseURI.toString();
		}
		if (mFragment!=null)
		{	uriString+='#'+mFragment;
		}
		URIdentifier uri = new URIdentifier(uriString);

		URRequest parent; 
		IRequestorSession session;
		if (mParentRequest!=null)
		{	parent = mParentRequest.getKernelRequest();
			session=parent.getSession();
		}
		else
		{	parent=null;
			session=null;
		}
		URRequest result = new URRequest(uri,null,session,mContext,mType,cwu,parent,mAspectClass);
		
		//add by-value arguments
		for (Iterator i=mValues.keySet().iterator(); i.hasNext(); )
		{	uriString = (String)i.next();
			IURRepresentation value = (IURRepresentation)mValues.get(uriString);
			result.addArg(new URIdentifier(uriString), value);
		}
		return result;
	}
	
	private void addArgument(String aName, String aURI, IURRepresentation aValue)
	{	if(aValue!=null) mValues.put(aURI, aValue);
		if(aName!=null)
		{	for (int i=aName.length()-1; i>=0; i--)
			{	char c = aName.charAt(i);
				if (!Character.isLetterOrDigit(c))
				{	throw new IllegalArgumentException("Invalid character in argument name");
				}
			}
			mURIs.put(aName, aURI);
		}
	}
	
	public void addArgument(String aName, String aURI) throws NKFException
	{	if (aName==null) throw new IllegalArgumentException("aName is null in addArgument()");
		if (aURI==null) throw new IllegalArgumentException("aURI is null in addArgument()");
		String uri = resolveURI(aURI);
		IURRepresentation byValue=null;
		if (mParentRequest!=null && aURI.startsWith("this:param:"))
		{	byValue = mParentRequest.getArgumentValue(uri);
		}
		addArgument(aName, uri, byValue);
	}
	
	public void addArgument(String aName, IURRepresentation aValue)
	{	if (aValue==null) throw new IllegalArgumentException("aValue is null in addArgument()");
		if (aName==null) throw new IllegalArgumentException("aName is null in addArgument()");
		String unique = createLiteralURI(aName);
		addArgument(aName, unique, aValue);
	}
	
	public void addArgument(String aName, IURAspect aValue)
	{	if (aValue==null) throw new IllegalArgumentException("aValue is null in addArgument()");
		if (aName==null) throw new IllegalArgumentException("aName is null in addArgument()");
		String unique = createLiteralURI(aName);
		IURRepresentation rep = NKFHelperImpl.createIntermediateRepresentationForAspect(aValue);
		addArgument(aName, unique, rep);
	}

	public void addSystemArgument(IURRepresentation aValue)
	{	if (aValue==null) throw new IllegalArgumentException("aValue is null in addSystemArgument()");
		addArgument(null, INKFRequestReadOnly.URI_SYSTEM, aValue);
	}
	
	public void addSystemArgument(IURAspect aValue)
	{	if (aValue==null) throw new IllegalArgumentException("aValue is null in addSystemArgument()");
		IURRepresentation rep = NKFHelperImpl.createIntermediateRepresentationForAspect(aValue);
		addArgument(null, INKFRequestReadOnly.URI_SYSTEM, rep);
	}

	public void setAspectClass(Class aAspectClass)
	{	if (aAspectClass==null) aAspectClass=IURAspect.class;
		mAspectClass = aAspectClass;
	}

	public Class getAspectClass()
	{	return mAspectClass;
	}
	
	public void setCWU(String aCWU)
	{	mCWU = aCWU;
	}
	
	public void setRequestType(int aType)
	{	mType = aType;
	}
	
	public void setURI(String aURI) throws NKFException
	{	if (aURI==null) throw new IllegalArgumentException("aURI is null in setURI()");
		mBaseURI = resolveURI(aURI);
	}
	
	public void setFragment(String aFragment)
	{	mFragment=aFragment;
	}
	
	/** Internal method to resolve relative URIs and this:param:* URIs
	 */
	String resolveURI(String aURI) throws NKFException
	{   String result=aURI;
		
		URI u2=URI.create(aURI);
	    //Resolve relative URIs agaunst CWU
	    if(!u2.isAbsolute())
	    {	if (mCWU==null)
			{	throw new NKFException("No CWU","Failed to resolve relative URI",aURI);
			}
			else
			{	URI u1=URI.create(mCWU);
				result = u1.resolve(u2).toString();
			}
	    }
	    //Manage this: address space
	    else if(aURI.startsWith("this:param:"))
	    {	String arg=aURI.substring(11);
			if (mParentRequest!=null)
			{	int fragIndex;
				if ((fragIndex=arg.indexOf('#'))>=0)
				{	// we have a fragment on the argument
					String fragment=arg.substring(fragIndex);
					arg=arg.substring(0,fragIndex);
					result = mParentRequest.getArgument(arg)+fragment;
				}
				else
				{	result = mParentRequest.getArgument(arg);
				}
			}
			else
			{	result=null;
			}
			if (result==null)
			{	throw new NKFException("Missing Argument","The "+arg+" argument was expected but not found on request",aURI);
			}
		}
	    return result;
	}
	
	private String createLiteralURI(String aName)
	{	StringBuffer sb=new StringBuffer(aName.length()+5);
		sb.append("var:");
		sb.append(aName);
		return sb.toString();
	}
}