/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: INKFRequest.java,v $
 * Version:       $Name:  $ $Revision: 1.14 $
 * Last Modified: $Date: 2004/09/08 09:49:16 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.nkf;

import com.ten60.netkernel.urii.IURRepresentation;
import com.ten60.netkernel.urii.IURAspect;

import java.net.URI;

/**
 * Wrapper around the construction of a sub-request from within an accessor
 * @author  pjr
 */
public interface INKFRequest
{   
	/** Sets the type of the request, defaults to RQT_SOURCE
	 * @param aType
	 */
	void setRequestType(int aType);
	
	/** Sets the base URI of the request, defaults to
	 * nothing and using it will fail if not set.
	 * @param aURI
	 */
	void setURI(String aURI) throws NKFException;
	
	/** Sets the current working URI of the request, defaults to
	 * the same CWU as the parent request
	 * @param aCWU
	 * @exception NKFException thrown if uri is relative and cannot be resolved
	 */
	void setCWU(String aCWU);
	
	/** Sets the class of aspect that is expected as a response to
	 * the request, will default to IURAspect which is the baseclass
	 * of all aspects and will allow anything to be returned
	 * @param aAspectClass if null it will default to IURAspect, and
	 * allow any aspect to be returned (i.e. no transreption will occur)
	 */
	void setAspectClass(Class aAspectClass);
	
	
	/** Adds a named pass-by-reference argument to the request.  A
	  * pass by reference argument is simply a URI to the resource.
	 * @param aName the name of the argument
	 * @param aURI the URI of the argument, if this is relative it
	 * will be resolved
	 * @exception NKFException thrown if relative URI cannot be resolved
	 */
	void addArgument(String aName, String aURI) throws NKFException;
	
	/** Adds a named pass-by-value argument to the request
	 * (a unique internal URI will be dynamically generated for the argument).
	 *  The argument is passed by value.
	 * @param aName
	 * @param aValue
	 */
	void addArgument(String aName, IURRepresentation aValue);
	
	/** Adds a named pass-by-value argument to the request from an
	 * aspect which has been created from internal processing of the accessor.
	 * (a unique internal URI will be dynamically generated for the argument).
	 * The argument is passed by value. The aspect is wrapped in a representation
	 * and is given metadata with zero cost, a mimetype of content/unknown and
	 * with a validity period of 1 day (assume infinite).
	 * @param aName
	 * @param aValue
	 */
	void addArgument(String aName, IURAspect aValue);

	/** Adds a system argument (for use in transrept and sink
	 * requests.
	 * @param aValue
	 */
	void addSystemArgument(IURRepresentation aValue);
	
	/** Adds a system argument (for use in transrept and sink
	 * requests.
	 * @param aValue
	 */
	 void addSystemArgument(IURAspect aValue);
	 
	/** Set a fragment identifier on to the request URI
	 *@param aFragment
	 */
	void setFragment(String aFragment);

}
