/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: INKFAsyncRequestHandle.java,v $
 * Version:       $Name:  $ $Revision: 1.2 $
 * Last Modified: $Date: 2004/08/19 14:17:44 $
 *****************************************************************************/
package org.ten60.netkernel.layer1.nkf;

import com.ten60.netkernel.urii.IURRepresentation;
/**
 * Proxy for issuing of an asynchronous subrequest
 * @author  tab
 */
public interface INKFAsyncRequestHandle
{
	/** Wait for an asynchronous subrequest to complete and return result
	 * - same effect as join(0)
	 *@return the result of executing the subrequest
	 *@exception NKFException an exception issued in trying to issue the sub request.
	 *@exception InterruptedException thrown if waiting for the request to complete
	 * is interrupted
	 */
	IURRepresentation join() throws NKFException, InterruptedException;
	
	/** Wait for an asynchronous subrequest to complete and return result
	 *@return the result of executing the subrequest, or null if a timeout
	 *@exception NKFException an exception issued in trying to issue the sub request.
	 *@exception InterruptedException thrown if waiting for the request to complete
	 * is interrupted
	 */
	IURRepresentation join(long aTimeout) throws NKFException, InterruptedException;
	
	/** Register a listener to be notified when the result of the request is
	 * available. It is important to note that this method cannot be used
	 * to effect the response from an accessor as the callback may be
	 * made after the accessor completes. This method is more suitable for
	 * asynchronous transports.
	 * @param aListener
	 */
	void setListener(INKFAsyncRequestListener aListener);
}