/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: ValidationAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.1 $
 * Last Modified: $Date: 2004/08/12 08:42:10 $
 *****************************************************************************/
package org.ten60.ura.util;

import com.ten60.netkernel.urii.*;

import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.util.*;
import java.io.*;

import java.net.*;
import java.util.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.util.*;
import org.ten60.netkernel.xml.representation.*;
import org.ten60.netkernel.xml.xahelper.*;
import org.ten60.netkernel.xml.xda.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 *
 * @author  tab
 */
public class ValidationAccessor extends XAccessor
{
	public ValidationAccessor()
	{	declareArgument(OPERAND, true, false);
		declareArgument(OPERATOR, true, false);
		declareThreadSafe();
	}
	
	public static final String TEST_NON_NULL="non-null";
	public static final String TEST_URI="uri";
	public static final String TEST_VERSION="version";
	public static final String TEST_ABSOLUTE_DIR="absolute-dir";
	public static final String TEST_DUPLICATE_MODULE="duplicate-module";
	public static final String TEST_POSITIVE_INTEGER="positive-integer";
	
	public IURRepresentation source(XAHelper aHelper) throws Exception
	{	
		IXDAReadOnly operand = aHelper.getOperand().getXDA();
		DOMXDA result = new DOMXDA(aHelper.getOperand().getReadOnlyDocument(),true);
		IXDAReadOnly operator = aHelper.getOperator().getXDA();
		for (IXDAReadOnlyIterator i = operator.readOnlyIterator("/validator/validation"); i.hasNext(); )
		{	i.next();
			String base = i.getText("base",true);
			IXDAIterator baseFragment = result.iterator(base);
			while (baseFragment.hasNext())
			{	baseFragment.next();
				String expr = i.getText("expr",true);
				String value = baseFragment.getText(expr,false);
				String test = i.getText("test",true);
				boolean failed = false;
				String message=null;
				if (test.equals(TEST_NON_NULL))
				{	failed = value.length()==0;
				}
				else if (test.equals(TEST_URI))
				{	try
					{	if (value.indexOf('\'')>=0)
						{	throw new URISyntaxException(value,"Illegal characters");
						}
						URI uri = new URI(value);
					}
					catch (URISyntaxException e)
					{	failed = true;
						message=e.getMessage();
					}
				}
				else if (test.equals(TEST_VERSION))
				{	try
					{	Version v = new Version(value);
					}
					catch (Exception e)
					{	failed = true;
						message=e.getMessage();
					}
				}
				else if (test.equals(TEST_ABSOLUTE_DIR))
				{	try
					{	URI uri = new URI("file:"+value);
						File f = new File(uri);
						if (!value.endsWith("/")) throw new Exception("Must end with forward slash to be directory");
						if (!uri.isAbsolute()) throw new Exception("Must be absolute");
					}
					catch (Exception e)
					{	failed = true;
						message=e.getMessage();
					}
				}
				else if (test.equals(TEST_DUPLICATE_MODULE))
				{	IXDAReadOnly moduleList = aHelper.getXResource(URI.create("netkernel:module")).getXDA();
					if (moduleList.isTrue("/modules/module[identity/uri='"+value+"']"))
					{	failed=true;
					}
				}
				else if (test.equals(TEST_POSITIVE_INTEGER))
				{	try
					{	int v = Integer.parseInt(value);
						if (v<0)
						{	throw new Exception();
						}
					}
					catch (Exception e)
					{	failed=true;
						message="Must be Integer greater or equal to zero";
					}
				}
				
				
				if (failed)
				{	for (IXDAReadOnlyIterator j = i.readOnlyIterator("set"); j.hasNext(); )
					{	j.next();
						String xpath = j.getText("@xpath",false);
						
						String message2 = j.getText(".",false);
						if (message!=null)
						{	boolean appendDetail = j.isTrue("@appendDetail");
							if (appendDetail)
							{	message2+=message;
							}
						}
						baseFragment.setText(xpath, message2);
					}
				}
			}
		}
		
		IURMeta meta = aHelper.getDependencyMeta("text/xml", 8);
		return DOMXDAAspect.create(meta,result);
	}
	
}