/******************************************************************************
 * (c) Copyright 2002,2003, 1060 Research Ltd
 *
 * This Software is licensed to You, the licensee, for use under the terms of
 * the 1060 Public License v1.0. Please read and agree to the 1060 Public
 * License v1.0 [www.1060research.com/license] before using or redistributing
 * this software.
 *
 * In summary the 1060 Public license has the following conditions.
 * A. You may use the Software free of charge provided you agree to the terms
 * laid out in the 1060 Public License v1.0
 * B. You are only permitted to use the Software with components or applications
 * that provide you with OSI Certified Open Source Code [www.opensource.org], or
 * for which licensing has been approved by 1060 Research Limited.
 * You may write your own software for execution by this Software provided any
 * distribution of your software with this Software complies with terms set out
 * in section 2 of the 1060 Public License v1.0
 * C. You may redistribute the Software provided you comply with the terms of
 * the 1060 Public License v1.0 and that no warranty is implied or given.
 * D. If you find you are unable to comply with this license you may seek to
 * obtain an alternative license from 1060 Research Limited by contacting
 * license@1060research.com or by visiting www.1060research.com
 *
 * NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC
 * LICENSE V1.0 FOR DETAILS
 *
 * THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ
 * THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license
 *
 * File:          $RCSfile: GoldenThreadAccessor.java,v $
 * Version:       $Name:  $ $Revision: 1.1 $
 * Last Modified: $Date: 2004/08/12 11:40:30 $
 *****************************************************************************/
package org.ten60.ura.util;

import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.urii.aspect.*;
import com.ten60.netkernel.util.*;
import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.module.*;
import com.ten60.netkernel.container.*;

import org.ten60.netkernel.layer1.accessor.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.representation.SimpleRepresentationImpl;
import org.ten60.netkernel.layer1.representation.MirrorRepresentation;
import org.ten60.netkernel.layer1.util.*;

import java.util.*;
import java.lang.ref.*;

/**
 * GoldenThreadAccessor can attach a golden thread identified by a param to any number of resources
 * This golden thread can then be cut and all resources will be invalidated (expired).
 * @author  tab
 */
public class GoldenThreadAccessor extends ActiveAccessorImpl
{
	private Map mTokenToGoldenThread;
	private static final String STATIC_KEY="org.ten60.netkernel.layer1.accessor.GoldenThreadAccessor";
	
	/** Creates a new instance of GoldenThreadAccessor */
	public GoldenThreadAccessor()
	{	super(4, true);
	}
	public void init(URIdentifier aURI, ModuleDefinition aModule, Container aContainer)
		throws NetKernelException
	{	super.init(aURI, aModule, aContainer);
		mTokenToGoldenThread = (Map)getContainer().getStatic(STATIC_KEY);
		if (mTokenToGoldenThread==null)
		{	mTokenToGoldenThread = new HashMap();
			getContainer().putStatic(STATIC_KEY,mTokenToGoldenThread);
		}
	}
	
	public void requestAsync(URRequest aRequest)
	{	try
		{	CompoundURIdentifier uri = new CompoundURIdentifier(aRequest.getURI());
			IURRepresentation result;
			if (uri.getType().equals("attachGoldenThread"))
			{	String token = uri.get(CompoundURIdentifier.PARAM);
				URIdentifier opdURI = new URIdentifier(uri.get(CompoundURIdentifier.OPERAND));
				IURRepresentation operand = this.getResource(opdURI, IURAspect.class,aRequest);
				result = attachGoldenThread(operand,token);
			}
			else if (uri.getType().equals("cutGoldenThread"))
			{	String token = uri.get(CompoundURIdentifier.PARAM);
				cutGoldenThread(token);
				result = VoidAspect.create();
			}
			else
			{	throw new NetKernelException("Operation not supported",null,aRequest.getURI().toString());
			}
			getScheduler().receiveAsyncResult(new URResult(aRequest,result));
		}
		catch (Throwable t)
		{	NetKernelException ex = new NetKernelException("Unhandled exception in GoldenThreadAccessor");
			ex.addCause(t);
			getScheduler().receiveAsyncException(new URResult(aRequest,NetKernelExceptionAspect.create(ex)));
		}
	}
	
	private synchronized IURRepresentation attachGoldenThread(IURRepresentation aOperand, String aToken) throws Throwable
	{	
		GoldenThread gt;
		WeakReference wr = (WeakReference)mTokenToGoldenThread.get(aToken);
		if (wr==null || wr.get()==null)
		{	gt = new GoldenThread();
			mTokenToGoldenThread.put(aToken, new WeakReference(gt));
		}
		else
		{	gt = (GoldenThread)wr.get();
		}
		DependencyMeta meta = new DependencyMeta(aOperand);
		meta.addDependency(gt);
		IURRepresentation result = MirrorRepresentation.create(meta, aOperand);
		return result;
	}
	
	private synchronized void cutGoldenThread(String aToken) throws Throwable
	{	WeakReference wr = (WeakReference)mTokenToGoldenThread.remove(aToken);
		if (wr!=null)
		{	GoldenThread gt = (GoldenThread)wr.get();
			if (gt!=null)
			{	gt.setExpired();
			}
		}
	}
	
	private class GoldenThread extends SimpleRepresentationImpl
	{
		private boolean mExpired;
		
		public GoldenThread()
		{	super(null);
			mMeta = createMeta();
			mExpired=false;
		}
		
		private IURMeta createMeta()
		{	return new MetaImpl("application/goldenthread", 0, 0)
			{	public boolean isExpired()
				{	return mExpired;
				}
			};
		}
		
		public void setExpired()
		{	mExpired=true;
		}
	}
	
}