/******************************************************************************
  (c) Copyright 2002,2003, 1060 Research Ltd                                   

  This Software is licensed to You, the licensee, for use under the terms of   
  the 1060 Public License v1.0. Please read and agree to the 1060 Public       
  License v1.0 [www.1060research.com/license] before using or redistributing   
  this software.                                                               

  In summary the 1060 Public license has the following conditions.             
  A. You may use the Software free of charge provided you agree to the terms   
  laid out in the 1060 Public License v1.0                                     
  B. You are only permitted to use the Software with components or applications
  that provide you with OSI Certified Open Source Code [www.opensource.org], or
  for which licensing has been approved by 1060 Research Limited.              
  You may write your own software for execution by this Software provided any  
  distribution of your software with this Software complies with terms set out 
  in section 2 of the 1060 Public License v1.0                                 
  C. You may redistribute the Software provided you comply with the terms of   
  the 1060 Public License v1.0 and that no warranty is implied or given.       
  D. If you find you are unable to comply with this license you may seek to    
  obtain an alternative license from 1060 Research Limited by contacting       
  license@1060research.com or by visiting www.1060research.com                 

  NO WARRANTY:  THIS SOFTWARE IS NOT COVERED BY ANY WARRANTY. SEE 1060 PUBLIC  
  LICENSE V1.0 FOR DETAILS                                                     

  THIS COPYRIGHT NOTICE IS *NOT* THE 1060 PUBLIC LICENSE v1.0. PLEASE READ     
  THE DISTRIBUTED 1060_Public_License.txt OR www.1060research.com/license      

  File:          $RCSfile: ExistsAccessor.java,v $
  Version:       $Name:  $ $Revision: 1.1 $
  Last Modified: $Date: 2004/08/12 11:40:31 $
 *****************************************************************************/
package org.ten60.ura.sys;

import org.ten60.netkernel.layer1.util.CompoundURIdentifier;
import org.ten60.netkernel.layer1.representation.*;
import org.ten60.netkernel.layer1.meta.*;
import org.ten60.netkernel.layer1.accessor.*;

import com.ten60.netkernel.urrequest.*;
import com.ten60.netkernel.urii.*;
import com.ten60.netkernel.util.*;
import com.ten60.netkernel.urii.aspect.IAspectBoolean;
import com.ten60.netkernel.urii.aspect.NetKernelExceptionAspect;

/**
 * Accessor to implement both Exists and Delete. It makes a request to the
 * scheduler to check existence or delete the operand URI
 * @author  tab
 */
public class ExistsAccessor extends ActiveAccessorImpl
{
	/** Creates a new instance of ExistsAccessor */
	public ExistsAccessor()
	{	super(4,true);
	}
	
	public void requestAsync(URRequest aRequest)
	{	try
		{	CompoundURIdentifier uri = new CompoundURIdentifier(aRequest.getURI());
			String type = uri.getType();
			String operandString = uri.get(CompoundURIdentifier.OPERAND);
			if (operandString==null) throw new IllegalArgumentException("operand required");
			URIdentifier operand = new URIdentifier(operandString);
			if (type.equals("exists"))
			{	
				if (aRequest.getArg(operand)==null)
				{	// pass-by-reference
					URRequest request = new URRequest(new URIdentifier(operandString), this, aRequest.getSession(), getModule(), URRequest.RQT_EXISTS, aRequest.getCWU(), aRequest, IAspectBoolean.class);
					getScheduler().requestAsync(request);
				}
				else
				{	// pass-by-value
					DependencyMeta meta = new DependencyMeta("application/boolean", 2, 0);
					meta.addDependency(aRequest.getArg(operand));
					IURAspect aspect = new BooleanAspect(true);
					IURRepresentation rep = new MonoRepresentationImpl(meta,aspect);
					getScheduler().receiveAsyncResult(new URResult(aRequest,rep));
				}
			}
			else if (type.equals("delete"))
			{	URRequest request = new URRequest(new URIdentifier(operandString), this, aRequest.getSession(), getModule(), URRequest.RQT_DELETE, aRequest.getCWU(), aRequest, IAspectBoolean.class);
				getScheduler().requestAsync(request);
			}
			else
			{	throw new IllegalArgumentException("unknown instruction "+type);
			}
		}
		catch (Exception e)
		{	NetKernelException nke = new NetKernelException("Unhandled Exception in Accessor");
			nke.addCause(e);
			URResult result = new URResult(aRequest,NetKernelExceptionAspect.create(nke));
			getScheduler().receiveAsyncException(result);
		}
	}
	
	/** The result we receive from the scheduler gets passed straight back to our requestor
	 */
	public void receiveAsyncResult(URResult aResult)
	{	URResult result = new URResult(aResult.getRequest().getParent(), aResult.getResource());
		getScheduler().receiveAsyncResult(result);
	}	
}