<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>
	<xsl:param name="param"><title>selected modules</title></xsl:param>
	
    <xsl:template match="/modules">
		<div>
		<script language="javascript">
		<xsl:comment>
			function viewPopup(url)
			{	popup = window.open(url,"popup","height=400,width=640");
			}
		</xsl:comment>
		</script>
		<table class="pseudocontrol" cellspacing="0">
			<tr class="title">
				<td colspan="4"><xsl:value-of select="$param/title/text()"/></td>
			</tr>
			<xsl:choose>
				<xsl:when test="count(module)">
					<xsl:apply-templates select="module">
						<xsl:sort select="name"/>
					</xsl:apply-templates>
				</xsl:when>
				<xsl:otherwise>
					<tr><td class="oddrow" colspan="4">no modules</td></tr>
				</xsl:otherwise>
			</xsl:choose>
		</table>
		</div>
    </xsl:template>
	
	<xsl:template match="module">
		<xsl:variable name="class">
			<xsl:choose>
				<xsl:when test="position() mod 2 = 0">
					<xsl:text>evenrow</xsl:text>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>oddrow</xsl:text>
				</xsl:otherwise>  
			</xsl:choose>
		</xsl:variable>
		<tr class="{$class}">
			<xsl:choose>
				<xsl:when test="editable">
					<td align="center" valign="middle">
						<input type="checkbox" name="module" value="{uri}@{version}">
							<xsl:if test="selected">
								<xsl:attribute name="checked"/>
							</xsl:if>
						</input>
					</td>
				</xsl:when>
				<xsl:otherwise>
					<td/>
				</xsl:otherwise>
			</xsl:choose>
			<td >
				<xsl:choose>
					<xsl:when test="icon">
						<img width="24" height="24" src="{icon}"/>
					</xsl:when>
					<xsl:otherwise>
						<img width="24" height="24" src="/mi+module@{uri}+version@{version}"/>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td valign="middle">
				<span style="font-size: larger; font-weight: bold"><xsl:value-of select="name"/></span>
				<xsl:if test="version"> v<xsl:value-of select="version"/></xsl:if><br/>
				<xsl:value-of select="desc"/>
			</td>
			<td>
				<xsl:if test="string-length(licenceURI) and string-length(licenceName)">
					<div>license: <a href="javascript:viewPopup('{licenceURI}')"><xsl:value-of select="licenceName"/></a></div>
				</xsl:if>
				<xsl:if test="descr">
					<div>readme: <a href="javascript:viewPopup('/install/viewInfo?xpath=/modules/module[uri=&quot;{uri}&quot; and version=&quot;{version}&quot;]')">release notes</a></div>
				</xsl:if>
			</td>
		</tr>
	</xsl:template>

</xsl:stylesheet> 
