<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>
	<xsl:param name="param"/>
	
    <xsl:template match="/modules">
		<xsl:variable name="doc" select="/"/>
		<modules>
			<xsl:for-each select="$param/nvp/*">
				<!--<xsl:variable name="pos" select="substring-after(name(),'mod')"/>
				<xsl:variable name="module" select="$doc/modules/module[position()=$pos]"/>
				<xsl:variable name="uri" select="$module/identity/uri/text()"/>
				<xsl:variable name="version" select="$module/identity/version/text()"/>-->
				<xsl:variable name="uri" select="substring-before(.,'@')"/>
				<xsl:variable name="version" select="substring-after(.,'@')"/>
				<!--<xsl:value-of select="$uri"/>-->
				<xsl:for-each select="$doc/modules/dependencies//module[uri=$uri and version=$version]">
					<xsl:call-template name="dependency"/>
				</xsl:for-each>
				<!--<xsl:call-template name="module"/>-->
			</xsl:for-each>
		</modules>
    </xsl:template>
	
	<xsl:template name="dependency">
		<xsl:for-each select="parent::module">
			<xsl:call-template name="module"/>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="module">
		<module>
			<uri><xsl:value-of select="uri"/></uri>
			<version><xsl:value-of select="version"/></version>
		</module>
	</xsl:template>

</xsl:stylesheet> 
