<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>
	<xsl:param name="param"/>
	
    <xsl:template match="/nvp">
		<modules>
			<xsl:for-each select="module">
				<xsl:variable name="uri" select="substring-before(.,'@')"/>
				<xsl:variable name="version" select="substring-after(.,'@')"/>
				<!--<xsl:value-of select="$uri"/>-->
				<xsl:for-each select="$param/modules/module[identity/uri=$uri and identity/version=$version]">
					<xsl:call-template name="module"/>
				</xsl:for-each>
			</xsl:for-each>
		</modules>
    </xsl:template>
	
	<xsl:template name="module">
		<module>
			<uri><xsl:value-of select="identity/uri"/></uri>
			<version><xsl:value-of select="identity/version"/></version>
			<name><xsl:value-of select="info/name"/></name>
			<desc><xsl:value-of select="info/description"/></desc>
		</module>
	</xsl:template>

</xsl:stylesheet> 
