<?xml version="1.0" encoding="UTF-8" ?>

<!--
    Document   : style_latest.xsl
    Created on : 24 March 2004, 09:25
    Author     : pjr
    Description:
        Purpose of transformation follows.
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>

    <!-- TODO customize transformation rules 
         syntax recommendation http://www.w3.org/TR/xslt 
    -->
    <xsl:template match="/">
        <div>
			<h2>Statistics</h2>
			<xsl:apply-templates/>
		</div>
    </xsl:template>
	
	<xsl:template match="null">
		<div style="font-size: 20px;">No bugs yet! This will show the overall system stats!</div>
	</xsl:template>
	
	<xsl:template match="results">
		<table>
			<tr bgcolor="#ccccff">
			<td>
				Status
			</td>
			<td>
				Total
			</td>
			</tr>
			<xsl:apply-templates select="row"/>
		</table>
	</xsl:template>

	<xsl:template match="row">
		<tr>
			<xsl:if test="position() mod 2">
				<xsl:attribute name="bgcolor">#eeeeff</xsl:attribute>
			</xsl:if>
			<td>
				<a xrl:resolve="href">
					<xsl:attribute name="href">
						[[xrl:process_search]]?bug_status=<xsl:value-of select="bug_status"/>&amp;limit=25
					</xsl:attribute>
					<xsl:value-of select="bug_status"/>
				</a>
			</td>
			<td>
				<xsl:value-of select="count"/>
			</td>
		</tr>
	</xsl:template>
</xsl:stylesheet>
