########################
#Set up Bugxter3 Database
#Run as user root in mysql database
########################
#Create Bugxter Database
########################
CREATE DATABASE IF NOT EXISTS bugxter3;

########################
#Grant access to user bugxter with password
#Change password to something more secure!
########################
GRANT SELECT,INSERT,UPDATE,DELETE,INDEX, ALTER,CREATE,DROP,REFERENCES,RELOAD ON bugxter3.* TO bugxter3@localhost IDENTIFIED BY 'changeme'; 
GRANT SELECT,INSERT,UPDATE,DELETE,INDEX, ALTER,CREATE,DROP,REFERENCES,RELOAD ON bugxter3.* TO bugxter3@localhost.localdomain IDENTIFIED BY 'changeme'; 
FLUSH PRIVILEGES;

#######################
#Set up Tables
#######################
CREATE TABLE IF NOT EXISTS bugxter3.products (
	id				MEDIUMINT(9) NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
    name			VARCHAR(128),
    description	    MEDIUMTEXT,
    urn				TINYTEXT,
	state			ENUM("LIVE", "OFFLINE", "OLD")
);

CREATE TABLE IF NOT EXISTS bugxter3.versions (
    id				MEDIUMINT(9) NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
	version			TINYTEXT,
    productid		MEDIUMINT(9),
	descr			MEDIUMTEXT
);

CREATE TABLE IF NOT EXISTS bugxter3.packages (
    parentid		MEDIUMINT(9),
	childid			MEDIUMINT(9)
);

CREATE TABLE IF NOT EXISTS bugxter3.bugs (
    id				MEDIUMINT NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
    created			DATETIME,
    reporter	    MEDIUMINT(9),
    assigned_to	    MEDIUMINT(9),
    qa_contact	    MEDIUMINT(9),
	title			MEDIUMTEXT,
    short_desc	    MEDIUMTEXT,
    buggy_file	    TEXT,
    priority	    ENUM("-", "P1", "P2",  "P3", "P4", "P5"),
    bug_severity    ENUM("blocker", "critical", "major", "normal" , "minor", "trivial", "enhancement"),
    bug_status	    ENUM("UNCONFIRMED", "NEW", "ASSIGNED", "REOPENED", "RESOLVED", "VERIFIED", "CLOSED"),
    status_report   MEDIUMTEXT,
    op_sys			ENUM("ALL", "Linux", "Win32", "SOLARIS", "HPUX", "AIX", "Other"),
    jvm_version	    TINYTEXT,
    resolution	    VARCHAR(64),
    target			VARCHAR(64),
    confirmed	    TINYINT(4),
    FULLTEXT	    (short_desc)
);

CREATE TABLE IF NOT EXISTS bugxter3.bugged (
    bugid			MEDIUMINT(9),
	versionid		MEDIUMINT(9)
);

CREATE TABLE IF NOT EXISTS bugxter3.activity (
    bugid		MEDIUMINT,
    who			MEDIUMINT(9),
    changed		DATETIME,
    fieldid		MEDIUMINT(9),
    old_value	MEDIUMTEXT,
    new_value	MEDIUMTEXT
);

CREATE TABLE IF NOT EXISTS bugxter3.comments (
	id			MEDIUMINT(9) NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
    bugid		MEDIUMINT,
    who			MEDIUMINT(9),
    changed		DATETIME,
    descr		MEDIUMTEXT
);

CREATE TABLE IF NOT EXISTS bugxter3.dependencies (
    bugid		MEDIUMINT(9),
    dependson	MEDIUMINT(9)
);

CREATE TABLE IF NOT EXISTS bugxter3.duplicates (
    original	MEDIUMINT(9),
    duplicate	MEDIUMINT(9)
);

CREATE TABLE IF NOT EXISTS bugxter3.attachments (
	id			MEDIUMINT(9) NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
    bugid		MEDIUMINT(9),
    submitter	MEDIUMINT(9),
    creation_ts	TIMESTAMP(14),
    description	MEDIUMTEXT,
    mimetype	TINYTEXT,
    ispatch		TINYINT(4),
    filename	MEDIUMTEXT,
    thedata		LONGBLOB
);

CREATE TABLE IF NOT EXISTS bugxter3.users (
    id				MEDIUMINT(9) NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
    login		    VARCHAR(128),
    hashedpassword  VARCHAR(128),
	password		VARCHAR(128),
    firstname	    VARCHAR(128),
	lastname		VARCHAR(255),
    email			VARCHAR(255),
    URL				VARCHAR(128),
    sms				VARCHAR(128),
	reminder		VARCHAR(255),
	answer			VARCHAR(255),
    status			ENUM("active", "pending", "disabled", "removed"),
	admin			TINYINT,
	created			TIMESTAMP(14)
);


CREATE TABLE IF NOT EXISTS bugxter3.affiliations (
    userid			MEDIUMINT(9),
    productid		MEDIUMINT(9),
	role			ENUM("admin", "qa", "developer", "member")
);

CREATE TABLE IF NOT EXISTS bugxter3.sessions (
	token		TEXT,
	userid		MEDIUMINT UNSIGNED ,
	created		DATETIME,
	expires		DATETIME
);

CREATE TABLE IF NOT EXISTS bugxter3.tickets (
	id			MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT, PRIMARY KEY(id),
	userid		MEDIUMINT UNSIGNED,
	guid		VARCHAR(255),
	created		DATETIME,
	type		ENUM("MEMBER", "BLOGREQ", "BLOGINVITE"),
	value		TINYINT
);

CREATE TABLE IF NOT EXISTS bugxter3.system (
	setting		varchar(128),
	value		TEXT
);

CREATE TABLE IF NOT EXISTS bugxter3.subscriptions (
	bugid		MEDIUMINT,
	userid		MEDIUMINT
);


#Set default system settings
INSERT INTO bugxter3.system VALUES ('WWWHOSTNAME', 'http://localhost:8080/');
INSERT INTO bugxter3.system VALUES ('HTTPPROXY', null);
INSERT INTO bugxter3.system VALUES ('SMTPHOSTNAME', 'localhost');
INSERT INTO bugxter3.system VALUES ('SMTPUSER', null);
INSERT INTO bugxter3.system VALUES ('SMTPPASSWORD', null);
INSERT INTO bugxter3.system VALUES ('EMAILSENDER', 'bugxter@localhost');
INSERT INTO bugxter3.system VALUES ('SMTPPOLLINTERVAL', '10000');

INSERT INTO bugxter3.users VALUES(
	null,
	'guest',
	MD5('guest'),
	'guest',
	'guest',
	'guest',
	null,
	null,
	null,
	null,
	null,
	'active',
	null
);

#Create dummy entries so queries work when nothing much has happened
INSERT INTO bugxter3.activity VALUES (
	null,
	null,
	null,
	null,
	null,
	null
);

INSERT INTO bugxter3.comments VALUES (
	null,
	null,
	null,
	null,
	null
);
