<?xml version="1.0" encoding="UTF-8" ?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xrl="http://1060.org/xrl">
    <xsl:output method="xml"/>

	
    <xsl:template match="/">
        <div>
			<xsl:apply-templates />
		</div>
    </xsl:template>
	
	<xsl:template match="null">
		<div style="visibilty: hidden;"/>
	</xsl:template>
	
	
	<xsl:template match="results">
		
		<h1>Membership Requests</h1>
		<form action="processMemberRequests" method="post">
		<input type="hidden" name="blogid">
			<xsl:attribute name="value"><xsl:value-of select="row[1]/blogid"/></xsl:attribute>
		</input>
		<table cellpadding="0" cellspacing="0" width="100%" class="table1">
				<tr class="table1-header">
					<td><b>Userid</b></td>
					<td><b>Name</b></td>
					<td><b>Email</b></td>
						<td>
							Message
						</td>
						<td>
							Accept
						</td>
						<td>
							Reject
						</td>
					</tr>
					
				<xsl:for-each select="row">
					<tr>
					<td>
						<xsl:value-of select="login"/>
					</td>
					<td>
						<xsl:value-of select="firstname"/><xsl:text> </xsl:text><xsl:value-of select="lastname"/>
					</td>
					<td>
						<xsl:value-of select="email"/>
					</td>
					<td>
						<xsl:copy-of select="message"/>
					</td>
						<td>
							<input name="item" type="checkbox">
								<xsl:attribute name="value">accept,<xsl:value-of select="userid"/></xsl:attribute>
							</input>
						</td>
						<td>
							<input name="reject" type="checkbox">
								<xsl:attribute name="value"><xsl:value-of select="userid"/></xsl:attribute>
							</input>
						</td>
					</tr>
				</xsl:for-each>
			</table>
			<input type="submit" style="float: right;" value="Process Membership"/>
			</form>
	</xsl:template>
	
	
</xsl:stylesheet> 
