<?xml version="1.0" encoding="UTF-8" ?>

<!--
    <comment>
		****************
		(C) 2003-2004, 1060 Research Limited. All rights reserved.
		Licensed under the 1060 Blogxter Non-commerical-Use License v1.0 -
		You are permitted to use this software only for non-commercial applications.
		For commercial licenses visit: http://www.1060research.com/license
		1060 is a registered trademark of 1060 Research Ltd.
		**********
		</comment>
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>

    <xsl:template match="/stats">
		<chart>
		  <properties>
			<type>area</type>
			<title></title>
			<omitLegend/>
			<width>300</width>
			<height>200</height>
			<xAxisTitle>Month</xAxisTitle>
			<yAxisTitle>Hits</yAxisTitle>
			<xAxisLabels>
				<xsl:choose>
					<xsl:when test="year/results/row">
						<xsl:for-each select="year/results/row">
							<xsl:sort select="day" order="descending"/>
							<label><xsl:value-of select="substring(dateMonthName, 1, 3)"/></label>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<label>0</label>
					</xsl:otherwise>
				</xsl:choose>
				
			</xAxisLabels>
		  </properties>
		  <data>
			<dataset color="807bffff" name="Hits">
				<xsl:choose>
					<xsl:when test="year/results/row">
						<xsl:for-each select="year/results/row">
							<xsl:sort select="day" order="descending"/>
							 <point>
								<xsl:attribute name="y">
									<xsl:value-of select="hits"/>
								</xsl:attribute>
							</point>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<point y="0"/>
					</xsl:otherwise>
				</xsl:choose>
			</dataset>
		  </data>
		</chart>
        
    </xsl:template>

</xsl:stylesheet> 
