<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:output method="xml"/>
	<xsl:param name="param"/>
    <xsl:template match="/data">
        <span>
			<xsl:apply-templates/>
		</span>
    </xsl:template>
	<xsl:template match="link">
		<span style="margin-left: 2px;">
			<xsl:choose>
				<xsl:when test="./text() = $param/nvp/page">
					<xsl:attribute name="class">selected</xsl:attribute>
					<xsl:value-of select="."/>
				</xsl:when>
				<xsl:otherwise>
					<a href="{$param/nvp/uri}/{$param/nvp/id}/{.}"><xsl:value-of select="."/></a>
				</xsl:otherwise>
			</xsl:choose>
		</span>
	</xsl:template>
	<xsl:template match="spacer">...</xsl:template>
	<xsl:template match="next">
		<span style="margin-left: 2px;">
		<a href="{$param/nvp/uri}/{$param/nvp/id}/{.}">next</a>
		
		</span>
	</xsl:template>
	<xsl:template match="back">
		<span style="margin-left: 2px;">
		<a href="{$param/nvp/uri}/{$param/nvp/id}/{.}">back</a>
		
		</span>
	</xsl:template>
</xsl:stylesheet>
